/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.sql.Timestamp;
import java.util.Vector;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.RunTimeStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.util.ArrayUtil;

public final class RunTimeStatisticsImpl
implements RunTimeStatistics {
    public String statementText;
    public String statementName;
    public String spsName;
    public long parseTime;
    public long bindTime;
    public long optimizeTime;
    public long generateTime;
    public long compileTime;
    public long executeTime;
    public Timestamp beginCompilationTimestamp;
    public Timestamp endCompilationTimestamp;
    public Timestamp beginExecutionTimestamp;
    public Timestamp endExecutionTimestamp;
    public ResultSetStatistics topResultSetStatistics;
    public ResultSetStatistics[] subqueryTrackingArray;

    public RunTimeStatisticsImpl(String string, String string2, String string3, long l, long l2, long l3, long l4, long l5, long l6, Timestamp timestamp, Timestamp timestamp2, Timestamp timestamp3, Timestamp timestamp4, ResultSetStatistics[] resultSetStatisticsArray, ResultSetStatistics resultSetStatistics) {
        this.spsName = string;
        this.statementName = string2;
        this.statementText = string3;
        this.compileTime = l;
        this.parseTime = l2;
        this.bindTime = l3;
        this.optimizeTime = l4;
        this.generateTime = l5;
        this.executeTime = l6;
        this.beginCompilationTimestamp = DataTypeUtilities.clone(timestamp);
        this.endCompilationTimestamp = DataTypeUtilities.clone(timestamp2);
        this.beginExecutionTimestamp = DataTypeUtilities.clone(timestamp3);
        this.endExecutionTimestamp = DataTypeUtilities.clone(timestamp4);
        this.subqueryTrackingArray = ArrayUtil.copy(resultSetStatisticsArray);
        this.topResultSetStatistics = resultSetStatistics;
    }

    @Override
    public long getCompileTimeInMillis() {
        return this.compileTime;
    }

    @Override
    public long getParseTimeInMillis() {
        return this.parseTime;
    }

    @Override
    public long getBindTimeInMillis() {
        return this.bindTime;
    }

    @Override
    public long getOptimizeTimeInMillis() {
        return this.optimizeTime;
    }

    @Override
    public long getGenerateTimeInMillis() {
        return this.generateTime;
    }

    @Override
    public long getExecuteTimeInMillis() {
        return this.executeTime;
    }

    @Override
    public Timestamp getBeginCompilationTimestamp() {
        return DataTypeUtilities.clone(this.beginCompilationTimestamp);
    }

    @Override
    public Timestamp getEndCompilationTimestamp() {
        return DataTypeUtilities.clone(this.endCompilationTimestamp);
    }

    @Override
    public Timestamp getBeginExecutionTimestamp() {
        return DataTypeUtilities.clone(this.beginExecutionTimestamp);
    }

    @Override
    public Timestamp getEndExecutionTimestamp() {
        return DataTypeUtilities.clone(this.endExecutionTimestamp);
    }

    @Override
    public String getStatementName() {
        return this.statementName;
    }

    @Override
    public String getSPSName() {
        return this.spsName;
    }

    @Override
    public String getStatementText() {
        return this.statementText;
    }

    @Override
    public double getEstimatedRowCount() {
        if (this.topResultSetStatistics == null) {
            return 0.0;
        }
        return this.topResultSetStatistics.getEstimatedRowCount();
    }

    @Override
    public String getStatementExecutionPlanText() {
        if (this.topResultSetStatistics == null) {
            return null;
        }
        Object object = "";
        if (this.subqueryTrackingArray != null) {
            boolean bl = false;
            for (int i = 0; i < this.subqueryTrackingArray.length; ++i) {
                if (this.subqueryTrackingArray[i] == null) continue;
                if (!bl) {
                    object = MessageService.getTextMessage("43Y21.U", new Object[0]) + ":\n";
                    bl = true;
                }
                object = (String)object + this.subqueryTrackingArray[i].getStatementExecutionPlanText(1);
            }
        }
        return (String)object + this.topResultSetStatistics.getStatementExecutionPlanText(0);
    }

    @Override
    public String getScanStatisticsText() {
        return this.topResultSetStatistics == null ? (String)null : this.topResultSetStatistics.getScanStatisticsText(null, 0);
    }

    @Override
    public String getScanStatisticsText(String string) {
        if (this.topResultSetStatistics == null) {
            return null;
        }
        String string2 = this.topResultSetStatistics.getScanStatisticsText(string, 0);
        return string2.equals("") ? null : string2;
    }

    public String toString() {
        String string = this.spsName != null ? "Stored Prepared Statement Name: \n\t" + this.spsName + "\n" : "";
        return string + MessageService.getTextMessage("43Y22.U", new Object[0]) + ": \n\t" + this.statementName + "\n" + MessageService.getTextMessage("43Y23.U", new Object[0]) + ": \n\t" + this.statementText + "\n" + MessageService.getTextMessage("43Y24.U", new Object[0]) + ": " + this.parseTime + "\n" + MessageService.getTextMessage("43Y25.U", new Object[0]) + ": " + this.bindTime + "\n" + MessageService.getTextMessage("43Y26.U", new Object[0]) + ": " + this.optimizeTime + "\n" + MessageService.getTextMessage("43Y27.U", new Object[0]) + ": " + this.generateTime + "\n" + MessageService.getTextMessage("43Y28.U", new Object[0]) + ": " + this.compileTime + "\n" + MessageService.getTextMessage("43Y29.U", new Object[0]) + ": " + this.executeTime + "\n" + MessageService.getTextMessage("43Y30.U", new Object[0]) + " : " + this.beginCompilationTimestamp + "\n" + MessageService.getTextMessage("43Y31.U", new Object[0]) + " : " + this.endCompilationTimestamp + "\n" + MessageService.getTextMessage("43Y32.U", new Object[0]) + " : " + this.beginExecutionTimestamp + "\n" + MessageService.getTextMessage("43Y33.U", new Object[0]) + " : " + this.endExecutionTimestamp + "\n" + MessageService.getTextMessage("43Y44.U", new Object[0]) + ": \n" + this.getStatementExecutionPlanText();
    }

    public Vector<ResultSetStatistics> getChildren() {
        Vector<ResultSetStatistics> vector = new Vector<ResultSetStatistics>();
        vector.addElement(this.topResultSetStatistics);
        return vector;
    }

    @Override
    public void acceptFromTopResultSet(XPLAINVisitor xPLAINVisitor) {
        if (this.topResultSetStatistics != null) {
            this.topResultSetStatistics.accept(xPLAINVisitor);
        }
    }
}

