/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment;

import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.ScheduledTimerDescriptor;
import com.sun.logging.LogDomains;
import jakarta.ejb.EJBHome;
import jakarta.ejb.EJBLocalHome;
import jakarta.ejb.EJBLocalObject;
import jakarta.ejb.EJBObject;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;
import org.glassfish.ejb.deployment.descriptor.FieldDescriptor;

public final class BeanMethodCalculatorImpl {
    private static final Logger LOG = LogDomains.getLogger(BeanMethodCalculatorImpl.class, (String)"jakarta.enterprise.system.tools.deployment", (boolean)false);
    private final String[] entityBeanHomeMethodsDisallowed = new String[]{"getEJBMetaData", "getHomeHandle"};
    private final String[] entityBeanRemoteMethodsDisallowed = new String[]{"getEJBHome", "getHandle", "getPrimaryKey", "isIdentical"};
    private final String[] entityBeanLocalHomeMethodsDisallowed = new String[0];
    private final String[] entityBeanLocalInterfaceMethodsDisallowed = new String[]{"getEJBLocalHome", "getPrimaryKey", "isIdentical"};
    private final String[] sessionBeanMethodsDisallowed = new String[]{"*"};
    private final String[] sessionLocalBeanMethodsDisallowed = new String[]{"*"};
    private Map<Class<?>, String[]> disallowedMethodsPerInterface;

    public Vector<FieldDescriptor> getPossibleCmpCmrFields(ClassLoader cl, String className) throws ClassNotFoundException {
        Method[] methods;
        Vector<FieldDescriptor> fieldDescriptors = new Vector<FieldDescriptor>();
        Class<?> theClass = cl.loadClass(className);
        for (Method next : methods = theClass.getMethods()) {
            String nextName = next.getName();
            int nextModifiers = next.getModifiers();
            if (!Modifier.isAbstract(nextModifiers) || !nextName.startsWith("get") || nextName.length() <= 3) continue;
            String field = nextName.substring(3, 4).toLowerCase(Locale.US) + nextName.substring(4);
            fieldDescriptors.add(new FieldDescriptor(field));
        }
        return fieldDescriptors;
    }

    public Vector<Method> getMethodsFor(com.sun.enterprise.deployment.EjbDescriptor ejbDescriptor, ClassLoader classLoader) throws ClassNotFoundException {
        Vector<Method> methods = new Vector<Method>();
        if (ejbDescriptor.isRemoteInterfacesSupported()) {
            BeanMethodCalculatorImpl.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getHomeClassName()));
            BeanMethodCalculatorImpl.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getRemoteClassName()));
        }
        if (ejbDescriptor.isRemoteBusinessInterfacesSupported()) {
            for (String intf : ejbDescriptor.getRemoteBusinessClassNames()) {
                BeanMethodCalculatorImpl.addAllInterfaceMethodsIn(methods, classLoader.loadClass(intf));
            }
        }
        if (ejbDescriptor.isLocalInterfacesSupported()) {
            BeanMethodCalculatorImpl.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getLocalHomeClassName()));
            BeanMethodCalculatorImpl.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getLocalClassName()));
        }
        if (ejbDescriptor.isLocalBusinessInterfacesSupported()) {
            for (String intf : ejbDescriptor.getLocalBusinessClassNames()) {
                BeanMethodCalculatorImpl.addAllInterfaceMethodsIn(methods, classLoader.loadClass(intf));
            }
        }
        if (ejbDescriptor.isLocalBean()) {
            BeanMethodCalculatorImpl.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getEjbClassName()));
        }
        if (ejbDescriptor.hasWebServiceEndpointInterface()) {
            BeanMethodCalculatorImpl.addAllInterfaceMethodsIn(methods, classLoader.loadClass(ejbDescriptor.getWebServiceEndpointInterfaceName()));
        }
        return methods;
    }

    private static void addAllInterfaceMethodsIn(Collection<Method> methods, Class<?> c) {
        methods.addAll(Arrays.asList(c.getMethods()));
    }

    public Collection<MethodDescriptor> getTransactionalMethodsFor(com.sun.enterprise.deployment.EjbDescriptor desc, ClassLoader loader) throws ClassNotFoundException {
        EjbDescriptor ejbDescriptor = (EjbDescriptor)desc;
        boolean statefulSessionBean = false;
        Vector<MethodDescriptor> methods = new Vector<MethodDescriptor>();
        if (ejbDescriptor instanceof EjbSessionDescriptor) {
            Method next;
            int n;
            int n2;
            Method[] methodArray;
            Method[] busIntfMethods;
            Class<?> businessIntf;
            Object disallowedMethods;
            statefulSessionBean = ((EjbSessionDescriptor)ejbDescriptor).isStateful();
            boolean singletonSessionBean = ((EjbSessionDescriptor)ejbDescriptor).isSingleton();
            if (ejbDescriptor.isRemoteInterfacesSupported()) {
                disallowedMethods = this.extractDisallowedMethodsFor(EJBObject.class, this.sessionBeanMethodsDisallowed);
                potentials = this.getTransactionMethodsFor(loader, ejbDescriptor.getRemoteClassName(), (Collection<Method>)disallowedMethods);
                this.transformAndAdd(potentials, "Remote", methods);
            }
            if (ejbDescriptor.isRemoteBusinessInterfacesSupported()) {
                for (String intfName : ejbDescriptor.getRemoteBusinessClassNames()) {
                    businessIntf = loader.loadClass(intfName);
                    methodArray = busIntfMethods = businessIntf.getMethods();
                    n2 = methodArray.length;
                    for (n = 0; n < n2; ++n) {
                        next = methodArray[n];
                        methods.add(new MethodDescriptor(next, "Remote"));
                    }
                }
            }
            if (ejbDescriptor.isLocalInterfacesSupported()) {
                disallowedMethods = this.extractDisallowedMethodsFor(EJBLocalObject.class, this.sessionLocalBeanMethodsDisallowed);
                potentials = this.getTransactionMethodsFor(loader, ejbDescriptor.getLocalClassName(), (Collection<Method>)disallowedMethods);
                this.transformAndAdd(potentials, "Local", methods);
            }
            if (ejbDescriptor.isLocalBusinessInterfacesSupported()) {
                for (String intfName : ejbDescriptor.getLocalBusinessClassNames()) {
                    businessIntf = loader.loadClass(intfName);
                    methodArray = busIntfMethods = businessIntf.getMethods();
                    n2 = methodArray.length;
                    for (n = 0; n < n2; ++n) {
                        next = methodArray[n];
                        methods.add(new MethodDescriptor(next, "Local"));
                    }
                }
            }
            if (ejbDescriptor.isLocalBean()) {
                Method[] busIntfMethods2;
                String intfName = ejbDescriptor.getEjbClassName();
                Class<?> businessIntf2 = loader.loadClass(intfName);
                for (Method next2 : busIntfMethods2 = businessIntf2.getMethods()) {
                    methods.add(new MethodDescriptor(next2, "Local"));
                }
            }
            if (ejbDescriptor.hasWebServiceEndpointInterface()) {
                Class<?> webServiceClass = loader.loadClass(ejbDescriptor.getWebServiceEndpointInterfaceName());
                Method[] webMethods = webServiceClass.getMethods();
                for (Method webMethod : webMethods) {
                    methods.add(new MethodDescriptor(webMethod, "ServiceEndpoint"));
                }
            }
            if (statefulSessionBean || singletonSessionBean) {
                Set<LifecycleCallbackDescriptor> lcds = ejbDescriptor.getLifecycleCallbackDescriptors();
                for (LifecycleCallbackDescriptor lcd : lcds) {
                    try {
                        Method m = lcd.getLifecycleCallbackMethodObject(loader);
                        MethodDescriptor md = new MethodDescriptor(m, "LifecycleCallback");
                        methods.add(md);
                    }
                    catch (Exception e) {
                        LOG.log(Level.FINE, "Lifecycle callback processing error", e);
                    }
                }
            }
        } else {
            String localHomeIntf;
            String homeIntf = ejbDescriptor.getHomeClassName();
            if (homeIntf != null) {
                Class<?> home = loader.loadClass(homeIntf);
                potentials = this.getTransactionMethodsFor(EJBHome.class, home);
                this.transformAndAdd(potentials, "Home", methods);
                String remoteIntf = ejbDescriptor.getRemoteClassName();
                Class<?> remote = loader.loadClass(remoteIntf);
                potentials = this.getTransactionMethodsFor(EJBObject.class, remote);
                this.transformAndAdd(potentials, "Remote", methods);
            }
            if ((localHomeIntf = ejbDescriptor.getLocalHomeClassName()) != null) {
                Class<?> home = loader.loadClass(localHomeIntf);
                Collection<Method> potentials = this.getTransactionMethodsFor(EJBLocalHome.class, home);
                this.transformAndAdd(potentials, "LocalHome", methods);
                String remoteIntf = ejbDescriptor.getLocalClassName();
                Class<?> remote = loader.loadClass(remoteIntf);
                potentials = this.getTransactionMethodsFor(EJBLocalObject.class, remote);
                this.transformAndAdd(potentials, "Local", methods);
            }
        }
        if (!statefulSessionBean && ejbDescriptor.isTimedObject()) {
            if (ejbDescriptor.getEjbTimeoutMethod() != null) {
                methods.add(ejbDescriptor.getEjbTimeoutMethod());
            }
            for (ScheduledTimerDescriptor schd : ejbDescriptor.getScheduledTimerDescriptors()) {
                methods.add(schd.getTimeoutMethod());
            }
        }
        return methods;
    }

    private Collection<Method> getTransactionMethodsFor(ClassLoader loader, String interfaceName, Collection<Method> disallowedMethods) throws ClassNotFoundException {
        Class<?> clazz = loader.loadClass(interfaceName);
        return this.getTransactionMethodsFor(clazz, disallowedMethods);
    }

    private Collection<Method> getTransactionMethodsFor(Class<?> interfaceImpl, Collection<Method> disallowedMethods) {
        Vector<Method> v = new Vector<Method>(Arrays.asList(interfaceImpl.getMethods()));
        v.removeAll(disallowedMethods);
        return v;
    }

    private Collection<Method> getTransactionMethodsFor(Class<?> interfaceType, Class<?> interfaceImpl) {
        Collection<Method> disallowedTransactionMethods = this.getDisallowedTransactionMethodsFor(interfaceType);
        return this.getTransactionMethodsFor(interfaceImpl, disallowedTransactionMethods);
    }

    private Collection<Method> getDisallowedTransactionMethodsFor(Class<?> interfaceType) {
        return this.extractDisallowedMethodsFor(interfaceType, this.getDisallowedMethodsNamesFor(interfaceType));
    }

    private Collection<Method> extractDisallowedMethodsFor(Class<?> interfaceType, String[] methodNames) {
        Method[] methods;
        Vector<Method> v = new Vector<Method>();
        if (methodNames.length == 0) {
            return v;
        }
        for (Method method : methods = interfaceType.getMethods()) {
            if (methodNames[0].equals("*")) {
                v.addElement(method);
                continue;
            }
            if (Arrays.binarySearch(methodNames, method.getName()) < 0) continue;
            v.addElement(method);
        }
        return v;
    }

    private void transformAndAdd(Collection<Method> methods, String methodIntf, Vector<MethodDescriptor> globalList) {
        for (Method m : methods) {
            MethodDescriptor md = new MethodDescriptor(m, methodIntf);
            globalList.add(md);
        }
    }

    private String[] getDisallowedMethodsNamesFor(Class interfaceType) {
        return this.getDisallowedMethodsNames().get(interfaceType);
    }

    protected Map<Class<?>, String[]> getDisallowedMethodsNames() {
        if (this.disallowedMethodsPerInterface == null) {
            this.disallowedMethodsPerInterface = new Hashtable();
            this.disallowedMethodsPerInterface.put(EJBHome.class, this.entityBeanHomeMethodsDisallowed);
            this.disallowedMethodsPerInterface.put(EJBObject.class, this.entityBeanRemoteMethodsDisallowed);
            this.disallowedMethodsPerInterface.put(EJBLocalHome.class, this.entityBeanLocalHomeMethodsDisallowed);
            this.disallowedMethodsPerInterface.put(EJBLocalObject.class, this.entityBeanLocalInterfaceMethodsDisallowed);
        }
        return this.disallowedMethodsPerInterface;
    }
}

