/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.databaseaccess;

import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.sessions.Session;

public abstract class ConnectionCustomizer
implements Cloneable {
    protected Accessor accessor;
    protected Session session;
    private ConnectionCustomizer prevCustomizer;

    protected ConnectionCustomizer(Accessor accessor, Session session) {
        this.accessor = accessor;
        this.session = session;
    }

    void setAccessor(Accessor accessor) {
        this.accessor = accessor;
    }

    public Accessor getAccessor() {
        return this.accessor;
    }

    public Session getSession() {
        return this.session;
    }

    public ConnectionCustomizer getPrevCustomizer() {
        return this.prevCustomizer;
    }

    public void setPrevCustomizer(ConnectionCustomizer prevCustomizer) {
        this.prevCustomizer = prevCustomizer;
    }

    public static ConnectionCustomizer createEmptyCustomizer(Session session) {
        return new Empty(null, session);
    }

    public abstract void customize();

    public abstract boolean isActive();

    public abstract void clear();

    static class Empty
    extends ConnectionCustomizer {
        public Empty(Accessor accessor, Session session) {
            super(accessor, session);
        }

        @Override
        public void customize() {
        }

        @Override
        public boolean isActive() {
            return false;
        }

        @Override
        public void clear() {
        }

        public boolean equals(Object obj) {
            return obj instanceof Empty;
        }
    }
}

