/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.runnablejar.commandline;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.glassfish.runnablejar.commandline.Arguments;
import org.glassfish.runnablejar.commandline.OrderedProperties;
import org.glassfish.runnablejar.commandline.UnknownPropertyException;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Option {
    PROPERTIES("properties", "--properties=FILE", "Load GlassFish properties from a file. This option can be repeated to load properties from multiple files. The propertes in the file can be any of the following:\n - Any properties supported by Embedded GlassFish. See SUPPORTED PROPERTIES\n - Any command line options with the name of the option as the key, without the initial hyphens, and the value of the option as the value.\n - Keys that start with the \"command.\" prefix, followed by any text. The value will be treated as a command to execute at startup.\n - Keys that start with the \"deploy.\" prefix, followed by any text. The value will be treated as an application to deploy at startup, as if it was specified on the command line.\n - If a property name doesn't match any already supported patterns and is not a recognized GlassFish property, it will be set as a system property, if it's not already defined.\n\nFor example, the GlassFish domain directory can be specified with the usual GlassFish Embedded property \"glassfish.embedded.tmpdir=myDomainDir\", as well as with the property \"domainDir=myDomainDir\" that represents the \"--domainDir=myDomainDir\" command-line option. A command to deploy an application can be specified via a property key \"command.deploy.app=deploy --contextroot=app myapp.war\". An application to deploy at startup with the default deploy behavior can be specified via a property key \"deploy.app=myapp.war\". The property \"properties\" can also be defined in this file, pointing to another file. In that case, properties will be loaded also from that file."){

        @Override
        public void handle(String value, Arguments arguments) {
            this.loadPropertiesFromFile(value, arguments);
        }
    }
    ,
    HTTP_PORT("httpPort", (Set)Set.of("port", "p"), "-p=PORT, --httpPort=PORT, --port=PORT", "Bind the HTTP listener to the specified port. If not set, the HTTP listener binds to port 8080 by default, unless it's disabled by the --noListener argument."){

        @Override
        public void handle(String value, Arguments arguments) {
            this.setPort("http-listener", value, arguments);
        }
    }
    ,
    HTTPS_PORT("httpsPort", "--httpsPort=PORT_NUMBER", "Bind the HTTPS listener to the specified port. If not set, the HTTPS listener is disabled by default."){

        @Override
        public void handle(String value, Arguments arguments) {
            this.setPort("https-listener", value, arguments);
        }
    }
    ,
    DOMAIN_CFG_FILE("domainConfigFile", "--domainConfigFile=FILE", "Set the location of domain configuration file (i.e., domain.xml) using which GlassFish should run."){

        @Override
        public void handle(String value, Arguments arguments) {
            arguments.glassFishProperties.setConfigFile(new File(value).toURI());
        }
    }
    ,
    DOMAIN_DIR("domainDir", (Set)Set.of("instanceRoot"), "--domainDir=DIRECTORY, --instanceRoot=DIRECTORY", "Set the instance root (a.k.a. domain directory) using which GlassFish should run."){

        @Override
        public void handle(String value, Arguments arguments) {
            arguments.glassFishProperties.setInstanceRoot(value);
        }
    }
    ,
    NO_LISTENER("noListener", (Set)Set.of("noPort"), "--noListener, --noPort", "Disable the HTTP listener, which is by default enabled and bound to port 8080."){

        @Override
        public void handle(String value, Arguments arguments) {
            this.setPort("http-listener", 0, arguments);
        }
    }
    ,
    AUTO_DEPLOY_DIR("autoDeployDir", "--autoDeployDir=DIRECTORY", "Files and directories in this directory will be deployed as applications (in random order), as if they were specified on the command line. The default directory name is 'autodeploy'."){

        @Override
        public void handle(String value, Arguments arguments) {
            this.loadApplicationsFromDirectory(value, arguments);
        }
    }
    ,
    LOG_LEVEL("logLevel", "--logLevel=LEVEL", "Set the log level of all loggers to LEVEL"){

        @Override
        public void handle(String logLevel, Arguments arguments) {
            this.setLogLevel(logLevel, arguments);
        }
    }
    ,
    LOG_PROPERTIES("logProperties", "--logProperties=FILE", "Set logging properties from file FILE"){

        @Override
        public void handle(String fileName, Arguments arguments) {
            try (BufferedInputStream logConfig = new BufferedInputStream(Files.newInputStream(Path.of(fileName, new String[0]), new OpenOption[0]));){
                LogManager.getLogManager().readConfiguration(logConfig);
            }
            catch (IOException | NullPointerException ex) {
                logger.log(Level.WARNING, ex, () -> "Could not open properties file " + fileName);
            }
        }
    }
    ,
    NO_INFO("noInfo", "--noInfo", "Disable printing information about deployed applications after startup"){

        @Override
        public void handle(String noInfo, Arguments arguments) {
            arguments.noInfo = noInfo == null || Boolean.valueOf(noInfo) != false;
        }
    }
    ,
    SHUTDOWN("shutdown", (Set)Set.of("shut-down", "stop"), "--shut-down, --shutdown, --stop", "Shut down GlassFish and the whole JVM process after server is started and initialized. This is useful to start the server, perform some action during startup (e.g. during application deployment), and shut down the application cleanly. Also useful for Class Data Sharing and similar startup optimizations - to start the server, get it to a ready state (applications deployed, etc.), and then shut down cleanly, so that the JVM can store the cached data."){

        @Override
        public void handle(String value, Arguments arguments) {
            arguments.shutdown = true;
        }
    }
    ,
    PROMPT("prompt", "--prompt", "Run interactive prompt that allows running admin commands. This is useful in development to manipulate a running GlassFish instance. After exiting the prompt, the server shuts down."){

        @Override
        public void handle(String value, Arguments arguments) {
            arguments.prompt = true;
        }
    }
    ,
    HELP("help", "--help", "Print this help"){

        @Override
        public void handle(String value, Arguments arguments) {
            arguments.askedForHelp = true;
        }
    };

    protected static final Logger logger;
    private String mainName;
    private Set<String> aliases;
    private String helpText;
    private String usage;

    private Option(String mainName, Set<String> aliases, String usage, String helpText) {
        this.mainName = mainName;
        this.aliases = aliases;
        this.usage = usage;
        this.helpText = helpText;
    }

    private Option(String mainName, String usage, String helpText) {
        this(mainName, Set.of(), usage, helpText);
    }

    public static Option from(String key) throws NoSuchElementException {
        try {
            return Option.valueOf(key);
        }
        catch (IllegalArgumentException e) {
            String upperCaseKey = key.toUpperCase();
            return Arrays.stream(Option.values()).filter(option -> Option.mainNameMatches(option, upperCaseKey) || Option.aliasesMatch(option, upperCaseKey)).findAny().get();
        }
    }

    public abstract void handle(String var1, Arguments var2);

    public String getMainName() {
        return this.mainName;
    }

    public Set<String> getAliases() {
        return this.aliases;
    }

    public String getHelpText() {
        return this.helpText;
    }

    public String getUsage() {
        return this.usage;
    }

    protected static boolean mainNameMatches(Option option, String upperCaseKey) {
        return option.mainName.toUpperCase().equals(upperCaseKey);
    }

    protected static boolean aliasesMatch(Option option, String upperCaseKey) {
        return option.aliases.stream().filter(alias -> alias.toUpperCase().equals(upperCaseKey)).findAny().isPresent();
    }

    protected void setPort(String listener, String value, Arguments arguments) throws NumberFormatException {
        this.setPort(listener, Integer.parseInt(value), arguments);
    }

    protected void setPort(String listener, int value, Arguments arguments) throws NumberFormatException {
        arguments.glassFishProperties.setPort(listener, value);
    }

    protected void loadPropertiesFromFile(String fileName, Arguments arguments) {
        try {
            OrderedProperties properties = new OrderedProperties();
            properties.load(Files.newBufferedReader(Paths.get(fileName, new String[0])));
            properties.forEachOrdered((key, value) -> {
                try {
                    arguments.setOption((String)key, (String)value);
                }
                catch (UnknownPropertyException e) {
                    logger.log(Level.WARNING, e, () -> "Invalid property '" + e.getKey() + "' in file " + fileName);
                }
            });
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e, () -> "Could not read properties from file " + fileName + " - " + e.getMessage());
        }
    }

    protected void loadApplicationsFromDirectory(String directoryName, Arguments arguments) {
        File directory = new File(directoryName);
        if (directory.isDirectory()) {
            for (File appFile : directory.listFiles()) {
                arguments.deployables.add(appFile.getAbsolutePath());
            }
        } else {
            logger.log(Level.WARNING, () -> "The path specified with the " + this.getUsage() + " option is not a directory: " + directoryName);
        }
    }

    protected void setLogLevel(String logLevel, Arguments arguments) {
        Level level;
        Logger rootLogger = Logger.getLogger("");
        try {
            level = Level.parse(logLevel);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new IllegalArgumentException("The value of the " + this.getMainName() + " option is not valid: " + logLevel);
        }
        for (Handler handler : rootLogger.getHandlers()) {
            handler.setLevel(level);
        }
        LogManager.getLogManager().getLoggerNames().asIterator().forEachRemaining(loggerName -> Logger.getLogger(loggerName).setLevel(level));
    }

    static {
        logger = Logger.getLogger(Option.class.getName());
    }
}

