/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.push;

import com.sun.faces.cdi.CdiUtils;
import com.sun.faces.push.WebsocketChannelManager;
import com.sun.faces.push.WebsocketSessionManager;
import com.sun.faces.push.WebsocketUserManager;
import com.sun.faces.util.Json;
import jakarta.enterprise.context.SessionScoped;
import jakarta.faces.context.FacesContext;
import jakarta.faces.push.PushContext;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;

public class WebsocketPushContext
implements PushContext {
    private static final long serialVersionUID = 1L;
    private String channel;
    private Map<String, String> sessionScope;
    private Map<String, String> viewScope;
    private WebsocketSessionManager socketSessions;
    private WebsocketUserManager socketUsers;

    public WebsocketPushContext(String channel, WebsocketSessionManager socketSessions, WebsocketUserManager socketUsers) {
        this.channel = channel;
        boolean hasSession = CdiUtils.isScopeActive(SessionScoped.class);
        this.sessionScope = hasSession ? WebsocketChannelManager.getSessionScope() : WebsocketChannelManager.EMPTY_SCOPE;
        this.viewScope = hasSession && FacesContext.getCurrentInstance() != null ? WebsocketChannelManager.getViewScope(true) : WebsocketChannelManager.EMPTY_SCOPE;
        this.socketSessions = socketSessions;
        this.socketUsers = socketUsers;
    }

    @Override
    public Set<Future<Void>> send(Object message) {
        return this.socketSessions.send(WebsocketChannelManager.getChannelId(this.channel, this.sessionScope, this.viewScope), Json.encode(message, new Json.Option[0]));
    }

    @Override
    public <S extends Serializable> Set<Future<Void>> send(Object message, S user) {
        return this.send(message, Collections.singleton(user)).get(user);
    }

    @Override
    public <S extends Serializable> Map<S, Set<Future<Void>>> send(Object message, Collection<S> users) {
        HashMap resultsByUser = new HashMap(users.size());
        String json = Json.encode(message, new Json.Option[0]);
        for (Serializable user : users) {
            Set<String> channelIds = this.socketUsers.getChannelIds(user, this.channel);
            HashSet<Future<Void>> results = new HashSet<Future<Void>>(channelIds.size());
            for (String channelId : channelIds) {
                results.addAll(this.socketSessions.send(channelId, json));
            }
            resultsByUser.put(user, results);
        }
        return resultsByUser;
    }
}

