/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.Cluster;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;

public class ClusterNotifyPartitionArrivalInfo {
    protected Logger logger = Globals.getLogger();
    private UID partitionID = null;
    private String targetBrokerID = null;
    private Long xid = null;
    private Cluster c = null;
    private GPacket pkt = null;

    private ClusterNotifyPartitionArrivalInfo(UID partitionID, String targetBrokerID, Long xid, Cluster c) {
        this.partitionID = partitionID;
        this.targetBrokerID = targetBrokerID;
        this.xid = xid;
        this.c = c;
    }

    private ClusterNotifyPartitionArrivalInfo(GPacket pkt, Cluster c) {
        this.pkt = pkt;
        this.c = c;
    }

    public static ClusterNotifyPartitionArrivalInfo newInstance(UID partitionID, String targetBrokerID, Long xid, Cluster c) {
        return new ClusterNotifyPartitionArrivalInfo(partitionID, targetBrokerID, xid, c);
    }

    public static ClusterNotifyPartitionArrivalInfo newInstance(GPacket pkt, Cluster c) {
        return new ClusterNotifyPartitionArrivalInfo(pkt, c);
    }

    public GPacket getGPacket() throws IOException {
        GPacket gp = GPacket.getInstance();
        gp.setType((short)75);
        gp.putProp((Object)"targetBrokerID", (Object)this.targetBrokerID);
        gp.putProp((Object)"partitionID", (Object)this.partitionID.longValue());
        gp.putProp((Object)"X", (Object)this.xid);
        gp.putProp((Object)"TS", (Object)System.currentTimeMillis());
        this.c.marshalBrokerAddress(this.c.getSelfAddress(), gp);
        gp.setBit(1, true);
        return gp;
    }

    public UID getPartitionID() {
        assert (this.pkt != null);
        return new UID(((Long)this.pkt.getProp((Object)"partitionID")).longValue());
    }

    public String getTargetBrokerID() {
        assert (this.pkt != null);
        return (String)this.pkt.getProp((Object)"targetBrokerID");
    }

    public Long getXid() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp((Object)"X");
    }

    public BrokerAddress getOwnerAddress() throws Exception {
        assert (this.pkt != null);
        return this.c.unmarshalBrokerAddress(this.pkt);
    }

    public Long getTimestamp() {
        assert (this.pkt != null);
        return (Long)this.pkt.getProp((Object)"TS");
    }

    public boolean needReply() {
        assert (this.pkt != null);
        return this.pkt.getBit(1);
    }

    public GPacket getReplyGPacket(int status, String reason) {
        assert (this.pkt != null);
        GPacket gp = GPacket.getInstance();
        gp.setType((short)76);
        gp.putProp((Object)"X", this.pkt.getProp((Object)"X"));
        gp.putProp((Object)"S", (Object)status);
        if (reason != null) {
            gp.putProp((Object)"reason", (Object)reason);
        }
        return gp;
    }

    public String toString() {
        if (this.pkt == null) {
            return "[" + String.valueOf(this.partitionID) + ", " + this.targetBrokerID + "]";
        }
        return "[" + String.valueOf(this.getPartitionID()) + ", " + this.getTargetBrokerID() + "]";
    }

    protected String getReplyToString(GPacket reply) {
        return this.toString() + ":[status=" + String.valueOf(reply.getProp((Object)"S")) + ", " + String.valueOf(reply.getProp((Object)"reason")) + "]";
    }

    public static Long getReplyPacketXid(GPacket gp) {
        return (Long)gp.getProp((Object)"X");
    }
}

