/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.handlers;

import com.sun.enterprise.deployment.ManagedScheduledExecutorDefinitionDescriptor;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.annotation.handlers.ConcurrencyDefinitionConvertor;
import com.sun.enterprise.deployment.annotation.handlers.ManagedScheduledExecutorDefinitionData;
import jakarta.enterprise.concurrent.ManagedScheduledExecutorDefinition;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.glassfish.config.support.TranslatedConfigView;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.jvnet.hk2.annotations.Service;

@Service
class ManagedScheduledExecutorDefinitionConverter
extends ConcurrencyDefinitionConvertor<ManagedScheduledExecutorDefinitionData, ManagedScheduledExecutorDefinitionDescriptor> {
    private static final System.Logger LOG = System.getLogger(ManagedScheduledExecutorDefinitionConverter.class.getName());

    ManagedScheduledExecutorDefinitionConverter() {
        super(ManagedScheduledExecutorDefinitionDescriptor.class, JavaEEResourceType.MSEDD);
    }

    @Override
    ManagedScheduledExecutorDefinitionDescriptor createDescriptor(ManagedScheduledExecutorDefinitionData data) {
        return new ManagedScheduledExecutorDefinitionDescriptor(data, MetadataSource.ANNOTATION);
    }

    @Override
    ManagedScheduledExecutorDefinitionData getData(ManagedScheduledExecutorDefinitionDescriptor descriptor) {
        return descriptor.getData();
    }

    Set<ManagedScheduledExecutorDefinitionData> convert(ManagedScheduledExecutorDefinition[] annotation) {
        LOG.log(System.Logger.Level.TRACE, "convert(annotation={0})", new Object[]{annotation});
        if (annotation == null) {
            return Collections.emptySet();
        }
        return Arrays.stream(annotation).map(this::convert).collect(Collectors.toSet());
    }

    ManagedScheduledExecutorDefinitionData convert(ManagedScheduledExecutorDefinition annotation) {
        LOG.log(System.Logger.Level.DEBUG, "convert(annotation={0})", annotation);
        ManagedScheduledExecutorDefinitionData data = new ManagedScheduledExecutorDefinitionData();
        data.setName(TranslatedConfigView.expandValue((String)annotation.name()));
        for (Class clazz : annotation.qualifiers()) {
            data.addQualifier(clazz.getCanonicalName());
        }
        data.setContext(TranslatedConfigView.expandValue((String)annotation.context()));
        data.setUseVirtualThreads(annotation.virtual());
        if (annotation.hungTaskThreshold() < 0L) {
            data.setHungTaskThreshold(0L);
        } else {
            data.setHungTaskThreshold(annotation.hungTaskThreshold());
        }
        if (annotation.maxAsync() < 0) {
            data.setMaxAsync(Integer.MAX_VALUE);
        } else {
            data.setMaxAsync(annotation.maxAsync());
        }
        return data;
    }

    @Override
    void merge(ManagedScheduledExecutorDefinitionData annotation, ManagedScheduledExecutorDefinitionData descriptor) {
        LOG.log(System.Logger.Level.DEBUG, "merge(annotation={0}, descriptor={1})", annotation, descriptor);
        if (!annotation.getName().equals(descriptor.getName())) {
            throw new IllegalArgumentException("Cannot merge managed executors with different names: " + annotation.getName() + " x " + descriptor.getName());
        }
        this.mergeQualifiers(annotation, descriptor);
        if (!descriptor.getUseVirtualThreads()) {
            descriptor.setUseVirtualThreads(annotation.getUseVirtualThreads());
        }
        if (descriptor.getHungTaskThreshold() <= 0L && annotation.getHungTaskThreshold() != 0L) {
            descriptor.setHungTaskThreshold(annotation.getHungTaskThreshold());
        }
        if (descriptor.getMaxAsync() <= 0) {
            descriptor.setMaxAsync(annotation.getMaxAsync());
        }
        if (descriptor.getContext() == null && annotation.getContext() != null && !annotation.getContext().isBlank()) {
            descriptor.setContext(TranslatedConfigView.expandValue((String)annotation.getContext()));
        }
    }
}

