/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver;

import com.sun.messaging.jmq.jmsserver.BrokerProcess;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.ServiceManager;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQDirectService;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsservice.JMSRABroker;
import com.sun.messaging.jmq.jmsservice.JMSService;
import java.util.Iterator;
import java.util.List;

public class JMSRA_BrokerProcess
extends BrokerProcess
implements JMSRABroker {
    private static final String DEFAULT_DIRECTMODE_SERVICE_NAME = "jmsdirect";

    @Override
    public JMSService getJMSService() {
        JMSService jmsService = this.getJMSService(DEFAULT_DIRECTMODE_SERVICE_NAME);
        if (jmsService != null) {
            return jmsService;
        }
        List serviceNames = ServiceManager.getAllServiceNames();
        Iterator iter = serviceNames.iterator();
        while (iter.hasNext()) {
            jmsService = this.getJMSService((String)iter.next());
            if (jmsService == null) continue;
            return jmsService;
        }
        return null;
    }

    @Override
    public JMSService getJMSService(String serviceName) {
        ServiceManager sm = Globals.getServiceManager();
        if (sm == null) {
            return null;
        }
        Service svc = sm.getService(serviceName);
        if (svc == null) {
            return null;
        }
        if (!(svc instanceof IMQService)) {
            return null;
        }
        IMQService imqSvc = (IMQService)svc;
        if (!imqSvc.isDirect()) {
            return null;
        }
        if (!(imqSvc instanceof IMQDirectService)) {
            return null;
        }
        IMQDirectService imqDirectSvc = (IMQDirectService)imqSvc;
        return imqDirectSvc.getJMSService();
    }
}

