/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.ajax;

import com.sun.data.provider.RowKey;
import com.sun.webui.jsf.component.Table2Column;
import com.sun.webui.jsf.component.Table2RowGroup;
import com.sun.webui.jsf.util.JsonUtilities;
import com.sun.webui.jsf.util.WidgetUtilities;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.render.Renderer;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;

public final class Table2RowGroupRenderer
extends Renderer {
    public void encodeBegin(FacesContext context, UIComponent component) {
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        Integer first;
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        String xjson = (String)context.getExternalContext().getRequestHeaderMap().get("X-JSON");
        if (xjson == null) {
            return;
        }
        JsonObject json = JsonUtilities.parseJsonObject(xjson);
        Table2RowGroup group = (Table2RowGroup)component;
        if (json != null && (first = Integer.valueOf(json.getInt("first", -1))) >= 0) {
            group.setFirst(first);
        }
        int maxRows = group.getRows();
        group.setRows(maxRows * 2);
        JsonArray rows = this.getRows(context, group);
        group.setRows(maxRows);
        if (rows != null) {
            JsonUtilities.writeJsonObject(json, (Writer)context.getResponseWriter());
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) {
    }

    public boolean getRendersChildren() {
        return true;
    }

    private JsonArray getRows(FacesContext context, Table2RowGroup component) throws IOException {
        if (context == null || component == null) {
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            return null;
        }
        if (component.getRowCount() == 0) {
            return null;
        }
        RowKey[] rowKeys = component.getRenderedRowKeys();
        if (rowKeys == null) {
            return null;
        }
        JsonArrayBuilder rowBuilder = JsonUtilities.JSON_BUILDER_FACTORY.createArrayBuilder();
        for (RowKey rowKey : rowKeys) {
            component.setRowKey(rowKey);
            if (!component.isRowAvailable()) break;
            JsonArrayBuilder cols = JsonUtilities.JSON_BUILDER_FACTORY.createArrayBuilder();
            Iterator kids = component.getTable2ColumnChildren();
            while (kids.hasNext()) {
                Table2Column col = (Table2Column)kids.next();
                if (!col.isRendered()) continue;
                Iterator grandKids = col.getChildren().iterator();
                while (grandKids.hasNext()) {
                    cols.add(WidgetUtilities.renderComponent(context, (UIComponent)grandKids.next()));
                }
            }
            rowBuilder.add(cols);
        }
        component.setRowKey(null);
        return rowBuilder.build();
    }
}

