/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.interceptor.builder;

import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.weld.interceptor.builder.InterceptionModelBuilder;
import org.jboss.weld.interceptor.reader.TargetClassInterceptorMetadata;
import org.jboss.weld.interceptor.spi.metadata.InterceptorClassMetadata;
import org.jboss.weld.interceptor.spi.model.InterceptionModel;
import org.jboss.weld.interceptor.spi.model.InterceptionType;
import org.jboss.weld.util.collections.ImmutableSet;

class InterceptionModelImpl
implements InterceptionModel {
    private final Map<InterceptionType, List<InterceptorClassMetadata<?>>> globalInterceptors;
    private final Map<InterceptionType, Map<Method, List<InterceptorClassMetadata<?>>>> methodBoundInterceptors;
    private final Set<Method> methodsIgnoringGlobalInterceptors;
    private final Set<InterceptorClassMetadata<?>> allInterceptors;
    private final boolean hasExternalNonConstructorInterceptors;
    private final TargetClassInterceptorMetadata targetClassInterceptorMetadata;
    private final Map<Member, Set<Annotation>> memberInterceptorBindings;
    private final Set<Annotation> classInterceptorBindings;

    InterceptionModelImpl(InterceptionModelBuilder builder) {
        this.hasExternalNonConstructorInterceptors = builder.isHasExternalNonConstructorInterceptors();
        this.globalInterceptors = builder.getGlobalInterceptors();
        this.methodBoundInterceptors = builder.getMethodBoundInterceptors();
        this.methodsIgnoringGlobalInterceptors = builder.getMethodsIgnoringGlobalInterceptors();
        this.allInterceptors = builder.getAllInterceptors();
        this.targetClassInterceptorMetadata = builder.getTargetClassInterceptorMetadata();
        this.memberInterceptorBindings = builder.getMemberInterceptorBindings();
        this.classInterceptorBindings = ImmutableSet.copyOf(builder.getClassInterceptorBindings());
    }

    @Override
    public List<InterceptorClassMetadata<?>> getInterceptors(InterceptionType interceptionType, Method method) {
        if (InterceptionType.AROUND_CONSTRUCT.equals((Object)interceptionType)) {
            throw new IllegalStateException("Cannot use getInterceptors() for @AroundConstruct interceptor lookup. Use getConstructorInvocationInterceptors() instead.");
        }
        if (interceptionType.isLifecycleCallback() && method != null) {
            throw new IllegalArgumentException("On a lifecycle callback, the associated method must be null");
        }
        if (!interceptionType.isLifecycleCallback() && method == null) {
            throw new IllegalArgumentException("Around-invoke and around-timeout interceptors are defined for a given method");
        }
        if (interceptionType.isLifecycleCallback()) {
            if (this.globalInterceptors.containsKey((Object)interceptionType)) {
                return this.globalInterceptors.get((Object)interceptionType);
            }
        } else {
            List<InterceptorClassMetadata<?>> list;
            Map<Method, List<InterceptorClassMetadata<?>>> map;
            ArrayList returnedInterceptors = new ArrayList();
            if (!this.methodsIgnoringGlobalInterceptors.contains(method) && this.globalInterceptors.containsKey((Object)interceptionType)) {
                returnedInterceptors.addAll((Collection)this.globalInterceptors.get((Object)interceptionType));
            }
            if ((map = this.methodBoundInterceptors.get((Object)interceptionType)) != null && (list = map.get(method)) != null) {
                returnedInterceptors.addAll(list);
            }
            return returnedInterceptors;
        }
        return Collections.emptyList();
    }

    @Override
    public Set<InterceptorClassMetadata<?>> getAllInterceptors() {
        return this.allInterceptors;
    }

    @Override
    public List<InterceptorClassMetadata<?>> getConstructorInvocationInterceptors() {
        if (this.globalInterceptors.containsKey((Object)InterceptionType.AROUND_CONSTRUCT)) {
            return this.globalInterceptors.get((Object)InterceptionType.AROUND_CONSTRUCT);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean hasExternalConstructorInterceptors() {
        return !this.getConstructorInvocationInterceptors().isEmpty();
    }

    @Override
    public boolean hasExternalNonConstructorInterceptors() {
        return this.hasExternalNonConstructorInterceptors;
    }

    @Override
    public boolean hasTargetClassInterceptors() {
        return this.targetClassInterceptorMetadata != null && this.targetClassInterceptorMetadata != TargetClassInterceptorMetadata.EMPTY_INSTANCE;
    }

    @Override
    public TargetClassInterceptorMetadata getTargetClassInterceptorMetadata() {
        return this.targetClassInterceptorMetadata;
    }

    @Override
    public Set<Annotation> getClassInterceptorBindings() {
        return this.classInterceptorBindings;
    }

    @Override
    public Set<Annotation> getMemberInterceptorBindings(Member member) {
        return this.memberInterceptorBindings.get(member);
    }
}

