/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.appclient.client.acc.AppClientInfo;

public class NestedAppClientInfo
extends AppClientInfo {
    private ApplicationClientDescriptor selectedAppClientDescriptor = null;
    private String displayNameFromCommandLine;

    public NestedAppClientInfo(boolean isJWS, Logger logger, File archive, Archivist archivist, String mainClassFromCommandLine, String displayNameFromCommandLine) {
        super(isJWS, logger, mainClassFromCommandLine);
        this.displayNameFromCommandLine = displayNameFromCommandLine;
    }

    @Override
    protected ApplicationClientDescriptor getAppClient(Archivist archivist) {
        if (this.selectedAppClientDescriptor != null) {
            return this.selectedAppClientDescriptor;
        }
        Application app = (Application)Application.class.cast(archivist.getDescriptor());
        Set embeddedAppClients = app.getBundleDescriptors(ApplicationClientDescriptor.class);
        if (embeddedAppClients.size() == 0) {
            throw new IllegalArgumentException(this.getLocalString("appclient.noEmbeddedAppClients", "The specified application module does not contain any app clients", new Object[0]));
        }
        if (embeddedAppClients.size() == 1) {
            this.selectedAppClientDescriptor = this.useFirstEmbeddedAppClient(embeddedAppClients, this.mainClassFromCommandLine);
        } else {
            this.selectedAppClientDescriptor = this.chooseFromEmbeddedAppClients(embeddedAppClients, this.mainClassFromCommandLine, this.displayNameFromCommandLine);
            if (this.selectedAppClientDescriptor == null) {
                if (this.mainClassFromCommandLine != null) {
                    throw new IllegalArgumentException(this.getLocalString("appclient.noMatchingClientUsingMainClass", "Could not locate an embedded app client matching the main class name {0}", this.mainClassFromCommandLine));
                }
                throw new IllegalArgumentException(this.getLocalString("appclient.noMatchingClientUsingDisplayName", "Could not locate an embedded app client matching the display name {0}", this.displayNameFromCommandLine));
            }
        }
        return this.selectedAppClientDescriptor;
    }

    private ApplicationClientDescriptor chooseFromEmbeddedAppClients(Set<ApplicationClientDescriptor> embeddedAppClients, String mainClassFromCommandLine, String displayNameFromCommandLine) {
        ApplicationClientDescriptor result = null;
        for (ApplicationClientDescriptor candidate : embeddedAppClients) {
            if (mainClassFromCommandLine != null) {
                if (!candidate.getMainClassName().equals(mainClassFromCommandLine)) continue;
                result = candidate;
                break;
            }
            if (!candidate.getName().equals(displayNameFromCommandLine)) continue;
            if (result == null) {
                result = candidate;
                continue;
            }
            throw new IllegalArgumentException(this.getLocalString("appclient.duplicate_display_name", "More than one nested app client was found with the display name {0}", displayNameFromCommandLine));
        }
        return result;
    }

    private ApplicationClientDescriptor useFirstEmbeddedAppClient(Set<ApplicationClientDescriptor> embeddedAppClients, String mainClassNameFromCommandLine) {
        ApplicationClientDescriptor result = null;
        Iterator<ApplicationClientDescriptor> it = embeddedAppClients.iterator();
        if (!it.hasNext()) {
            throw new IllegalStateException(this.getLocalString("appclient.unexpectedEndOfEmbeddedClients", "The application module seems to contain one app client but the iterator reported no more elements prematurely", new Object[0]));
        }
        result = embeddedAppClients.iterator().next();
        if (mainClassNameFromCommandLine != null) {
            result.setMainClassName(mainClassNameFromCommandLine);
        }
        return result;
    }

    @Override
    protected List<String> getClassPaths(ReadableArchive archive) {
        ArrayList<String> paths = new ArrayList<String>();
        String appRoot = archive.getURI().toASCIIString();
        paths.add(appRoot);
        Enumeration en = archive.entries();
        while (en.hasMoreElements()) {
            String entryName = (String)en.nextElement();
            if (!entryName.endsWith(".jar")) continue;
            String entry = appRoot + File.separator + entryName;
            paths.add(entry);
        }
        return paths;
    }

    @Override
    protected String getAppClientRoot(ReadableArchive archive, ApplicationClientDescriptor descriptor) {
        String appRoot = archive.getURI().toASCIIString();
        String moduleUri = descriptor.getModuleDescriptor().getArchiveUri();
        String moduleRoot = appRoot + File.separator + FileUtils.makeFriendlyFilename((String)moduleUri);
        return moduleRoot;
    }
}

