/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.lang.model.AnnotationMember;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.jboss.weld.lite.extension.translator.AnnotationMemberImpl;

final class AnnotationProxy {
    private AnnotationProxy() {
    }

    static <T extends Annotation> T create(Class<T> clazz, Map<String, AnnotationMember> members) {
        Class[] interfaces = new Class[]{clazz};
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (Map.Entry<String, AnnotationMember> member : members.entrySet()) {
            values.put(member.getKey(), ((AnnotationMemberImpl)member.getValue()).value);
        }
        for (Method method : clazz.getDeclaredMethods()) {
            Object value;
            String methodName = method.getName();
            if (values.containsKey(methodName) || (value = method.getDefaultValue()) == null) continue;
            values.put(methodName, value);
        }
        return (T)((Annotation)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, (InvocationHandler)new AnnotationInvocationHandler(clazz, values)));
    }

    private static final class AnnotationInvocationHandler
    implements InvocationHandler {
        private final Class<? extends Annotation> clazz;
        private final Map<String, Object> members;

        AnnotationInvocationHandler(Class<? extends Annotation> clazz, Map<String, Object> members) {
            this.clazz = clazz;
            this.members = members;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Exception {
            if ("annotationType".equals(method.getName())) {
                return this.clazz;
            }
            if ("toString".equals(method.getName())) {
                StringJoiner joiner = new StringJoiner(", ", "(", ")");
                joiner.setEmptyValue("");
                for (Map.Entry<String, Object> member : this.members.entrySet()) {
                    joiner.add(member.getKey() + "=" + String.valueOf(member.getValue()));
                }
                return "@" + this.clazz.getName() + joiner.toString();
            }
            if ("equals".equals(method.getName())) {
                Annotation that;
                Object other = args[0];
                if (other instanceof Annotation && this.clazz.equals((that = (Annotation)other).annotationType())) {
                    for (Method member : this.clazz.getDeclaredMethods()) {
                        Object thatValue;
                        Object thisValue = this.members.get(member.getName());
                        if (Objects.deepEquals(thisValue, thatValue = method.invoke((Object)that, new Object[0]))) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
            if ("hashCode".equals(method.getName())) {
                Object[] components = new Object[this.members.size() + 1];
                components[0] = this.clazz;
                int i = 1;
                for (Object memberValue : this.members.values()) {
                    components[i++] = memberValue;
                }
                return Objects.hash(components);
            }
            return this.members.get(method.getName());
        }
    }
}

