/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bean;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.BeanAttributes;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.InjectionTargetFactory;
import org.jboss.weld.bean.AbstractSyntheticBean;
import org.jboss.weld.manager.BeanManagerImpl;

public class SyntheticClassBean<T>
extends AbstractSyntheticBean<T> {
    protected final InjectionTarget<T> producer;

    public SyntheticClassBean(BeanAttributes<T> attributes, Class<T> beanClass, InjectionTargetFactory<T> factory, BeanManagerImpl manager) {
        super(attributes, manager, beanClass);
        this.producer = factory.createInjectionTarget(this);
    }

    @Override
    public T create(CreationalContext<T> creationalContext) {
        T instance = this.producer.produce(creationalContext);
        this.producer.inject(instance, creationalContext);
        this.producer.postConstruct(instance);
        return instance;
    }

    @Override
    public void destroy(T instance, CreationalContext<T> creationalContext) {
        try {
            this.producer.preDestroy(instance);
            this.producer.dispose(instance);
        }
        finally {
            creationalContext.release();
        }
    }

    @Override
    protected InjectionTarget<T> getProducer() {
        return this.producer;
    }

    @Override
    public String toString() {
        return "SyntheticClassBean [attributes=" + String.valueOf(this.attributes()) + ", injectionTarget=" + String.valueOf(this.producer.getClass()) + ", beanClass=" + String.valueOf(this.getBeanClass()) + "]";
    }
}

