/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.misc;

import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import java.security.PublicKey;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

public class PublicKeyCertSelector
implements CertSelector {
    PublicKey key = null;

    public PublicKeyCertSelector(PublicKey pk) {
        this.key = pk;
    }

    @Override
    public boolean match(Certificate cert) {
        if (cert == null) {
            return false;
        }
        if (this.key == null) {
            throw new XWSSecurityRuntimeException("PublicKeyCertSelector instantiated with Null Key");
        }
        if (cert instanceof X509Certificate) {
            X509Certificate x509Cert = (X509Certificate)cert;
            return this.key.equals(x509Cert.getPublicKey());
        }
        return false;
    }

    @Override
    public Object clone() {
        return new PublicKeyCertSelector(this.key);
    }
}

