/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl;

import com.sun.xml.wss.ProcessingContext;
import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.SecurityHeader;
import com.sun.xml.wss.impl.FilterProcessingContext;
import com.sun.xml.wss.impl.HarnessUtil;
import com.sun.xml.wss.impl.PolicyResolver;
import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.ProcessingContextImpl;
import com.sun.xml.wss.impl.TargetResolverImpl;
import com.sun.xml.wss.impl.filter.AuthenticationTokenFilter;
import com.sun.xml.wss.impl.filter.DumpFilter;
import com.sun.xml.wss.impl.filter.EncryptionFilter;
import com.sun.xml.wss.impl.filter.SignatureConfirmationFilter;
import com.sun.xml.wss.impl.filter.SignatureFilter;
import com.sun.xml.wss.impl.filter.TimestampFilter;
import com.sun.xml.wss.impl.policy.PolicyAlternatives;
import com.sun.xml.wss.impl.policy.PolicyUtils;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.impl.policy.verifier.MessagePolicyVerifier;
import com.sun.xml.wss.logging.LogStringsMessages;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class NewSecurityRecipient {
    private static Logger log = Logger.getLogger("javax.enterprise.resource.xml.webservices.security", "com.sun.xml.wss.logging.LogStrings");
    private static SOAPFactory sFactory = null;

    private NewSecurityRecipient() {
    }

    public static void validateMessage(ProcessingContext context) throws XWSSecurityException {
        PolicyResolver opResolver;
        HarnessUtil.validateContext(context);
        FilterProcessingContext fpContext = new FilterProcessingContext(context);
        fpContext.isInboundMessage(true);
        SecurityPolicy pol = fpContext.getSecurityPolicy();
        MessagePolicy msgPolicy = null;
        List<MessagePolicy> messagePolicies = null;
        if (pol instanceof MessagePolicy) {
            msgPolicy = (MessagePolicy)pol;
        } else if (pol instanceof PolicyAlternatives) {
            messagePolicies = ((PolicyAlternatives)pol).getSecurityPolicy();
        }
        if (msgPolicy != null && msgPolicy.dumpMessages()) {
            DumpFilter.process(fpContext);
        }
        fpContext.setSecurityPolicyVersion(((ProcessingContextImpl)context).getSecurityPolicyVersion());
        fpContext.setExtraneousProperty("EnableWSS11PolicyReceiver", "true");
        ArrayList scList = new ArrayList();
        fpContext.setExtraneousProperty("receivedSignValues", scList);
        fpContext.setMode(3);
        NewSecurityRecipient.pProcess(fpContext);
        if (PolicyUtils.isEmpty(pol) && (opResolver = (PolicyResolver)fpContext.getExtraneousProperty("OperationResolver")) != null) {
            pol = opResolver.resolvePolicy(fpContext);
        }
        if (pol instanceof MessagePolicy) {
            msgPolicy = (MessagePolicy)pol;
        } else if (pol instanceof PolicyAlternatives) {
            messagePolicies = ((PolicyAlternatives)pol).getSecurityPolicy();
            msgPolicy = messagePolicies != null ? messagePolicies.get(0) : null;
        }
        try {
            if (msgPolicy == null || msgPolicy.size() == 0 && fpContext.getSOAPMessage().getSOAPBody().hasFault()) {
                fpContext.getSecurableSoapMessage().deleteSecurityHeader();
                fpContext.getSOAPMessage().saveChanges();
                return;
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0307_NONCE_ENCTYPE_INVALID(), ex);
            throw new XWSSecurityException(ex);
        }
        TargetResolverImpl targetResolver = new TargetResolverImpl(context);
        MessagePolicyVerifier mpv = new MessagePolicyVerifier(context, targetResolver);
        mpv.verifyPolicy(fpContext.getInferredSecurityPolicy(), msgPolicy);
        try {
            fpContext.getSecurableSoapMessage().deleteSecurityHeader();
            fpContext.getSOAPMessage().saveChanges();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0370_ERROR_DELETING_SECHEADER(), ex);
            throw new XWSSecurityException(ex);
        }
    }

    private static void processCurrentHeader(FilterProcessingContext fpContext, SOAPElement current, boolean isSecondary) throws XWSSecurityException {
        String elementName = current.getLocalName();
        if (isSecondary) {
            if ("UsernameToken".equals(elementName)) {
                AuthenticationTokenFilter.processUserNameToken(fpContext);
            } else if ("Timestamp".equals(elementName)) {
                TimestampFilter.process(fpContext);
            } else if ("SignatureConfirmation".equals(elementName)) {
                SignatureConfirmationFilter.process(fpContext);
            } else if (!"BinarySecurityToken".equals(elementName)) {
                if ("Assertion".equals(elementName)) {
                    AuthenticationTokenFilter.processSamlToken(fpContext);
                } else if (!"SecurityTokenReference".equals(elementName) && "SecurityContextToken".equals(elementName)) {
                    // empty if block
                }
            }
        } else if ("Signature".equals(elementName)) {
            SignatureFilter.process(fpContext);
        } else if ("EncryptedKey".equals(elementName)) {
            Iterator iter = null;
            try {
                iter = current.getChildElements(sFactory.createName("ReferenceList", "xenc", "http://www.w3.org/2001/04/xmlenc#"));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, LogStringsMessages.WSS_0252_FAILEDTO_GET_CHILD_ELEMENT(), e);
                throw new XWSSecurityException(e);
            }
            if (iter.hasNext()) {
                EncryptionFilter.process(fpContext);
            }
        } else if ("ReferenceList".equals(elementName)) {
            EncryptionFilter.process(fpContext);
        } else if ("EncryptedData".equals(elementName)) {
            EncryptionFilter.process(fpContext);
        } else if (!HarnessUtil.isSecondaryHeaderElement(current)) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0204_ILLEGAL_HEADER_BLOCK(elementName));
            HarnessUtil.throwWssSoapFault("Unrecognized header block: " + elementName);
        }
    }

    private static void pProcess(FilterProcessingContext fpContext) throws XWSSecurityException {
        SOAPElement current;
        SecurityHeader header = fpContext.getSecurableSoapMessage().findSecurityHeader();
        MessagePolicy policy = (MessagePolicy)fpContext.getSecurityPolicy();
        if (header == null) {
            if (policy != null) {
                if (PolicyTypeUtil.messagePolicy(policy)) {
                    if (!policy.isEmpty()) {
                        log.log(Level.SEVERE, LogStringsMessages.WSS_0253_INVALID_MESSAGE());
                        throw new XWSSecurityException("Message does not conform to configured policy: No Security Header found in incoming message");
                    }
                } else {
                    log.log(Level.SEVERE, LogStringsMessages.WSS_0253_INVALID_MESSAGE());
                    throw new XWSSecurityException("Message does not conform to configured policy: No Security Header found in incoming message");
                }
            }
            return;
        }
        if (policy != null && policy.dumpMessages()) {
            DumpFilter.process(fpContext);
        }
        SOAPElement first = current = header.getCurrentHeaderBlockElement();
        while (current != null) {
            NewSecurityRecipient.processCurrentHeader(fpContext, current, false);
            current = header.getCurrentHeaderBlockElement();
        }
        current = first;
        header.setCurrentHeaderElement(current);
        while (current != null) {
            NewSecurityRecipient.processCurrentHeader(fpContext, current, true);
            current = header.getCurrentHeaderBlockElement();
        }
    }

    public static void handleFault(ProcessingContext context) {
    }

    static {
        try {
            sFactory = SOAPFactory.newInstance();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSS_0397_SOAP_FACTORY_EXCEPTION(), ex);
            throw new RuntimeException(ex);
        }
    }
}

