/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.FailedProperties40;
import org.apache.derby.client.am.LogicalDatabaseMetaData;
import org.apache.derby.client.am.SqlException;

public class LogicalConnection
implements Connection {
    ClientConnection physicalConnection_;
    private ClientPooledConnection pooledConnection_ = null;
    private LogicalDatabaseMetaData logicalDatabaseMetaData = null;

    public LogicalConnection(ClientConnection clientConnection, ClientPooledConnection clientPooledConnection) throws SqlException {
        this.physicalConnection_ = clientConnection;
        this.pooledConnection_ = clientPooledConnection;
        try {
            this.checkForNullPhysicalConnection();
        }
        catch (SQLException sQLException) {
            throw new SqlException(sQLException);
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public synchronized void nullPhysicalConnection() {
        this.physicalConnection_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        ClientPooledConnection clientPooledConnection = this.pooledConnection_;
        synchronized (clientPooledConnection) {
            LogicalConnection logicalConnection = this;
            synchronized (logicalConnection) {
                try {
                    if (this.physicalConnection_ == null) {
                        return;
                    }
                    if (this.physicalConnection_.agent_.loggingEnabled()) {
                        this.physicalConnection_.agent_.logWriter_.traceEntry(this, "close", new Object[0]);
                    }
                    if (this.physicalConnection_.isClosed()) {
                        this.pooledConnection_.informListeners(new SqlException(null, new ClientMessageId("08003.C.3"), new Object[0]));
                    } else {
                        this.physicalConnection_.checkForTransactionInProgress();
                        this.physicalConnection_.closeForReuse(this.pooledConnection_.isStatementPoolingEnabled());
                        if (!this.physicalConnection_.isGlobalPending_()) {
                            this.pooledConnection_.recycleConnection();
                        }
                    }
                    this.physicalConnection_ = null;
                    this.pooledConnection_.nullLogicalConnection();
                }
                catch (SqlException sqlException) {
                    throw sqlException.getSQLException();
                }
            }
        }
    }

    public synchronized void closeWithoutRecyclingToPool() throws SqlException {
        if (this.physicalConnection_ == null) {
            return;
        }
        this.physicalConnection_.checkForTransactionInProgress();
        try {
            if (this.physicalConnection_.isClosed()) {
                throw new SqlException(null, new ClientMessageId("08003"), new Object[0]);
            }
        }
        finally {
            this.physicalConnection_.closeForReuse(this.pooledConnection_.isStatementPoolingEnabled());
            this.physicalConnection_ = null;
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.physicalConnection_ == null) {
            return true;
        }
        return this.physicalConnection_.isClosed();
    }

    protected final void checkForNullPhysicalConnection() throws SQLException {
        if (this.physicalConnection_ == null) {
            SqlException sqlException = new SqlException(null, new ClientMessageId("08003"), new Object[0]);
            throw sqlException.getSQLException();
        }
    }

    final void notifyException(SQLException sQLException) {
        if (this.physicalConnection_ != null) {
            this.pooledConnection_.informListeners(new SqlException(sQLException));
        }
    }

    @Override
    public synchronized Statement createStatement() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createStatement();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareStatement(string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareCall(string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized String nativeSQL(String string) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.nativeSQL(string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setAutoCommit(bl);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized boolean getAutoCommit() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getAutoCommit();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized void commit() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.commit();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized void rollback() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.rollback();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized void setTransactionIsolation(int n) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setTransactionIsolation(n);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized int getTransactionIsolation() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getTransactionIsolation();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getWarnings();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.clearWarnings();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            if (this.logicalDatabaseMetaData == null) {
                this.logicalDatabaseMetaData = this.newLogicalDatabaseMetaData();
            }
            return this.logicalDatabaseMetaData;
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    protected LogicalDatabaseMetaData newLogicalDatabaseMetaData() throws SQLException {
        return new LogicalDatabaseMetaData(this, this.physicalConnection_.agent_.logWriter_);
    }

    final synchronized DatabaseMetaData getRealMetaDataObject() throws SQLException {
        if (this.isClosed()) {
            throw new SqlException(this.physicalConnection_ == null ? null : this.physicalConnection_.agent_.logWriter_, new ClientMessageId("08003"), new Object[0]).getSQLException();
        }
        return this.physicalConnection_.getMetaData();
    }

    @Override
    public synchronized void setReadOnly(boolean bl) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setReadOnly(bl);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized boolean isReadOnly() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.isReadOnly();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized void setCatalog(String string) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setCatalog(string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized String getCatalog() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getCatalog();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized Statement createStatement(int n, int n2) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createStatement(n, n2);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareStatement(string, n, n2);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareCall(string, n, n2);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized Map<String, Class<?>> getTypeMap() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getTypeMap();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setTypeMap(map);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized Statement createStatement(int n, int n2, int n3) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createStatement(n, n2, n3);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareCall(string, n, n2, n3);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareStatement(string, n, n2, n3);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareStatement(string, n);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareStatement(string, nArray);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.prepareStatement(string, stringArray);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized void setHoldability(int n) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setHoldability(n);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized int getHoldability() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getHoldability();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.setSavepoint();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized Savepoint setSavepoint(String string) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.setSavepoint(string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.rollback(savepoint);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.releaseSavepoint(savepoint);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    public int getTransactionID() {
        if (this.physicalConnection_ == null) {
            return -1;
        }
        return this.physicalConnection_.getTransactionID();
    }

    public int getServerVersion() {
        if (this.physicalConnection_ == null) {
            return -1;
        }
        return this.physicalConnection_.getServerVersion();
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createArrayOf(string, objectArray);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Blob createBlob() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createBlob();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createClob();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public NClob createNClob() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createNClob();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createSQLXML();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.createStruct(string, objectArray);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getClientInfo();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getClientInfo(string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized boolean isValid(int n) throws SQLException {
        try {
            if (this.physicalConnection_ == null) {
                return false;
            }
            return this.physicalConnection_.isValid(n);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return clazz.isInstance(this);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setClientInfo(properties);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            this.notifyException(sQLClientInfoException);
            throw sQLClientInfoException;
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), new FailedProperties40(properties).getProperties());
        }
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setClientInfo(string, string2);
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            this.notifyException(sQLClientInfoException);
            throw sQLClientInfoException;
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw new SQLClientInfoException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), new FailedProperties40(FailedProperties40.makeProperties(string, string2)).getProperties());
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            try {
                return clazz.cast(this);
            }
            catch (ClassCastException classCastException) {
                throw new SqlException(null, new ClientMessageId("XJ128.S"), clazz).getSQLException();
            }
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized String getSchema() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getSchema();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public synchronized void setSchema(String string) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setSchema(string);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        try {
            if (this.physicalConnection_ != null) {
                this.physicalConnection_.abort(executor);
            }
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            return this.physicalConnection_.getNetworkTimeout();
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int n) throws SQLException {
        try {
            this.checkForNullPhysicalConnection();
            this.physicalConnection_.setNetworkTimeout(executor, n);
        }
        catch (SQLException sQLException) {
            this.notifyException(sQLException);
            throw sQLException;
        }
    }
}

