/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.connection;

import com.sun.jdo.api.persistence.support.JDODataStoreException;
import com.sun.jdo.api.persistence.support.Transaction;
import com.sun.jdo.spi.persistence.support.sqlstore.LogHelperSQLStore;
import com.sun.jdo.spi.persistence.support.sqlstore.connection.ConnectionManager;
import com.sun.jdo.spi.persistence.support.sqlstore.ejb.EJBHelper;
import com.sun.jdo.spi.persistence.utility.Linkable;
import com.sun.jdo.spi.persistence.utility.logging.Logger;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;

public class ConnectionImpl
implements Connection,
Linkable {
    private Connection connection;
    private String url;
    private String userName;
    Linkable previous;
    Linkable next;
    private boolean pooled;
    private Transaction transaction;
    boolean freePending;
    ConnectionManager connectionManager;
    private static Logger logger = LogHelperSQLStore.getLogger();

    public ConnectionImpl(Connection conn, String url, String userName, ConnectionManager connMgr) {
        this.connection = conn;
        this.url = url;
        this.userName = userName;
        this.previous = null;
        this.next = null;
        this.pooled = false;
        this.transaction = null;
        this.freePending = false;
        this.connectionManager = connMgr;
    }

    @Override
    public synchronized Statement createStatement() throws SQLException {
        this.checkXact();
        return this.connection.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkXact();
        return this.connection.prepareStatement(sql);
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql) throws SQLException {
        return this.connection.prepareCall(sql);
    }

    @Override
    public synchronized String nativeSQL(String sql) throws SQLException {
        return this.connection.nativeSQL(sql);
    }

    @Override
    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection.setAutoCommit(autoCommit);
    }

    @Override
    public synchronized boolean getAutoCommit() throws SQLException {
        return this.connection.getAutoCommit();
    }

    @Override
    public synchronized void commit() throws SQLException {
        this.connection.commit();
        if (this.freePending) {
            if (this.connectionManager.shutDownPending) {
                try {
                    this.connection.close();
                    logger.finest("sqlstore.connectionimpl.commit");
                }
                catch (SQLException sQLException) {}
            } else {
                this.freePending = false;
                this.connectionManager.freeList.insertAtTail((Linkable)this);
            }
        }
        if (EJBHelper.isManaged()) {
            this.closeInternal();
        }
    }

    @Override
    public synchronized void rollback() throws SQLException {
        logger.finest("sqlstore.connectionimpl.rollback");
        this.connection.rollback();
        if (this.freePending) {
            if (this.connectionManager.shutDownPending) {
                this.connection.close();
                logger.finest("sqlstore.connectionimpl.rollback.close");
            } else {
                this.freePending = false;
                this.connectionManager.freeList.insertAtTail((Linkable)this);
            }
        }
        if (EJBHelper.isManaged()) {
            this.closeInternal();
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        if (EJBHelper.isManaged()) {
            logger.finest("sqlstore.connectionimpl.close");
            return;
        }
        this.closeInternal();
    }

    private synchronized void closeInternal() throws SQLException {
        boolean debug = logger.isLoggable(300);
        ConnectionImpl conn = this;
        if (debug) {
            logger.finest("sqlstore.connectionimpl.close_arg", (Object)conn);
        }
        conn.connectionManager.busyList.removeFromList((Linkable)conn);
        if (conn.xactPending()) {
            conn.setFreePending(true);
            if (debug) {
                logger.finest("sqlstore.connectionimpl.close.freepending");
            }
        } else if (conn.getPooled() && !conn.connectionManager.shutDownPending) {
            conn.connectionManager.freeList.insertAtTail((Linkable)conn);
            if (debug) {
                logger.finest("sqlstore.connectionimpl.close.putfreelist");
            }
        } else if (EJBHelper.isManaged()) {
            this.connection.close();
            if (debug) {
                logger.finest("sqlstore.connectionimpl.close.exit");
            }
        } else {
            this.connectionManager.replaceFreeConnection(this);
            if (debug) {
                logger.finest("sqlstore.connectionimpl.close.replaced");
            }
        }
    }

    protected void release() {
        try {
            this.connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        logger.finest("sqlstore.connectionimpl.close.connrelease");
    }

    @Override
    public synchronized boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    @Override
    public synchronized void setReadOnly(boolean readOnly) throws SQLException {
        this.connection.setReadOnly(readOnly);
    }

    @Override
    public synchronized boolean isReadOnly() throws SQLException {
        return this.connection.isReadOnly();
    }

    @Override
    public synchronized void setCatalog(String catalog) throws SQLException {
        this.connection.setCatalog(catalog);
    }

    @Override
    public synchronized String getCatalog() throws SQLException {
        return this.connection.getCatalog();
    }

    @Override
    public synchronized void setTransactionIsolation(int level) throws SQLException {
        this.connection.setTransactionIsolation(level);
    }

    @Override
    public synchronized int getTransactionIsolation() throws SQLException {
        return this.connection.getTransactionIsolation();
    }

    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        return this.connection.getWarnings();
    }

    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.connection.clearWarnings();
    }

    public synchronized Map getTypeMap() throws SQLException {
        return this.connection.getTypeMap();
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        this.connection.setTypeMap(map);
    }

    @Override
    public synchronized void setHoldability(int holdability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized int getHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized Savepoint setSavepoint(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new UnsupportedOperationException();
    }

    synchronized void checkXact() throws SQLException {
    }

    synchronized void setFreePending(boolean freePending) {
        this.freePending = freePending;
    }

    synchronized boolean getFreePending() {
        return this.freePending;
    }

    synchronized boolean xactPending() {
        return this.transaction != null;
    }

    public Linkable getPrevious() {
        return this.previous;
    }

    public void setPrevious(Linkable conn) {
        this.previous = conn;
    }

    public Linkable getNext() {
        return this.next;
    }

    public void setNext(Linkable conn) {
        this.next = conn;
    }

    synchronized boolean getPooled() {
        return this.pooled;
    }

    synchronized void setPooled(boolean flag) {
        this.pooled = flag;
    }

    synchronized String getURL() {
        return this.url;
    }

    synchronized String getUserName() {
        return this.userName;
    }

    public synchronized void internalCommit() {
        logger.finest("sqlstore.connectionimpl.internalcommit");
        try {
            this.connection.commit();
        }
        catch (Exception e1) {
            try {
                this.connection.rollback();
                this.clearXact();
            }
            catch (Exception exception) {
                this.clearXact();
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            throw new JDODataStoreException(null, e1);
        }
        finally {
            this.clearXact();
        }
    }

    public synchronized void internalRollback() {
        logger.finest("sqlstore.connectionimpl.internalrollback");
        try {
            this.connection.rollback();
        }
        catch (Exception exception) {
        }
        finally {
            this.clearXact();
        }
    }

    private void clearXact() {
        logger.finest("sqlstore.connectionimpl.clearxact");
        try {
            if (this.freePending) {
                this.freePending = false;
                if (this.pooled) {
                    this.connectionManager.disassociateXact(this.transaction, this, true);
                    logger.finest("sqlstore.connectionimpl.pendingdisassocxact");
                } else {
                    this.connectionManager.disassociateXact(this.transaction, this, false);
                    this.connection.close();
                    logger.finest("sqlstore.connectionimpl.clearxact.close");
                }
            } else {
                this.connectionManager.disassociateXact(this.transaction, this, false);
                logger.finest("sqlstore.connectionimpl.clearxact.disassocxact");
            }
            this.connection.setAutoCommit(true);
        }
        catch (SQLException sQLException) {
        }
        finally {
            this.transaction = null;
        }
    }

    public synchronized String toString() {
        int xactIsolation = 0;
        Object buffer = "Connect@";
        String strTran = this.transaction == null ? "  NULL" : this.transaction.toString();
        int hash = this.hashCode();
        try {
            xactIsolation = this.getTransactionIsolation();
        }
        catch (SQLException ex) {
            xactIsolation = -1;
        }
        buffer = (String)buffer + hash + "\n  pooled = " + this.pooled + "\n  freePending = " + this.freePending + "\n  xactIsolation = " + xactIsolation + "\n  Tran = " + strTran + "\n";
        return buffer;
    }

    protected void finalize() {
        try {
            this.connection.close();
            logger.finest("sqlstore.connectionimpl.finalize");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getSchema() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

