/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.util;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.common.DataSourceObjectBuilder;
import com.sun.logging.LogDomains;
import jakarta.resource.ResourceException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MethodExecutor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Logger _logger = LogDomains.getLogger(MethodExecutor.class, (String)"jakarta.enterprise.resource.resourceadapter");
    private static StringManager sm = StringManager.getManager(DataSourceObjectBuilder.class);
    private static final String newline = System.getProperty("line.separator");

    public void runJavaBeanMethod(String value, Method method, Object obj) throws ResourceException {
        if (value == null || value.trim().equals("")) {
            return;
        }
        Class<?>[] parameters = method.getParameterTypes();
        if (parameters.length == 1) {
            Object[] values = new Object[]{this.convertType(parameters[0], value)};
            try {
                method.setAccessible(true);
                method.invoke(obj, values);
            }
            catch (IllegalAccessException | SecurityException | InvocationTargetException iae) {
                _logger.log(Level.SEVERE, "jdbc.exc_jb_val", value);
                _logger.log(Level.SEVERE, "", iae);
                throw new ResourceException(sm.getString("me.access_denied", (Object)method.getName()));
            }
            catch (IllegalArgumentException ie) {
                _logger.log(Level.SEVERE, "jdbc.exc_jb_val", value);
                _logger.log(Level.SEVERE, "", ie);
                throw new ResourceException(sm.getString("me.illegal_args", (Object)method.getName()));
            }
        }
    }

    public void runMethod(Method method, Object obj, List<String> values) throws ResourceException {
        Class<?>[] parameters = method.getParameterTypes();
        if (values.size() != parameters.length) {
            return;
        }
        Object[] actualValues = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            String val = values.get(i);
            actualValues[i] = val.trim().equals("NULL") ? null : this.convertType(parameters[i], val);
        }
        try {
            method.setAccessible(true);
            method.invoke(obj, actualValues);
        }
        catch (IllegalAccessException | SecurityException | InvocationTargetException iae) {
            _logger.log(Level.SEVERE, "jdbc.exc_jb_val", values);
            _logger.log(Level.SEVERE, "", iae);
            throw new ResourceException(sm.getString("me.access_denied", (Object)method.getName()));
        }
        catch (IllegalArgumentException ie) {
            _logger.log(Level.SEVERE, "jdbc.exc_jb_val", values);
            _logger.log(Level.SEVERE, "", ie);
            throw new ResourceException(sm.getString("me.illegal_args", (Object)method.getName()));
        }
    }

    private Object convertType(Class<?> type, String parameter) throws ResourceException {
        try {
            Properties p;
            String typeName = type.getName();
            if (typeName.equals("java.lang.String") || typeName.equals("java.lang.Object")) {
                return parameter;
            }
            if (typeName.equals("int") || typeName.equals("java.lang.Integer")) {
                return Integer.valueOf(parameter);
            }
            if (typeName.equals("short") || typeName.equals("java.lang.Short")) {
                return Short.valueOf(parameter);
            }
            if (typeName.equals("byte") || typeName.equals("java.lang.Byte")) {
                return Byte.valueOf(parameter);
            }
            if (typeName.equals("long") || typeName.equals("java.lang.Long")) {
                return Long.valueOf(parameter);
            }
            if (typeName.equals("float") || typeName.equals("java.lang.Float")) {
                return Float.valueOf(parameter);
            }
            if (typeName.equals("double") || typeName.equals("java.lang.Double")) {
                return Double.valueOf(parameter);
            }
            if (typeName.equals("java.math.BigDecimal")) {
                return new BigDecimal(parameter);
            }
            if (typeName.equals("java.math.BigInteger")) {
                return new BigInteger(parameter);
            }
            if (typeName.equals("boolean") || typeName.equals("java.lang.Boolean")) {
                return Boolean.valueOf(parameter);
            }
            if (typeName.equals("java.util.Properties") && (p = this.stringToProperties(parameter)) != null) {
                return p;
            }
            return parameter;
        }
        catch (NumberFormatException nfe) {
            _logger.log(Level.SEVERE, "jdbc.exc_nfe", parameter);
            String msg = sm.getString("me.invalid_param", (Object)parameter);
            throw new ResourceException(msg);
        }
    }

    public Object invokeMethod(Object object, String methodName, Class<?>[] valueTypes, Object ... values) throws ResourceException {
        Method actualMethod;
        Object returnValue = null;
        try {
            actualMethod = object.getClass().getMethod(methodName, valueTypes);
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new ResourceException((Throwable)ex);
        }
        if (actualMethod != null) {
            try {
                actualMethod.setAccessible(true);
                returnValue = actualMethod.invoke(object, values);
            }
            catch (IllegalAccessError | ReflectiveOperationException e) {
                if (e.getCause() != null) {
                    throw new ResourceException(e.getCause());
                }
                throw new ResourceException(e);
            }
        }
        return returnValue;
    }

    private Properties stringToProperties(String parameter) {
        if (parameter == null) {
            return null;
        }
        String s = parameter.trim();
        if (!s.startsWith("(") || !s.endsWith(")")) {
            return null;
        }
        s = s.substring(1, s.length() - 1);
        s = s.replaceAll("(?<!\\\\),", newline);
        s = s.replaceAll("\\\\,", ",");
        Properties p = new Properties();
        Properties prop = new Properties();
        try {
            p.load(new StringBufferInputStream(s));
        }
        catch (IOException ex) {
            _logger.log(Level.FINEST, "Parsing string to properties: {0}", ex.getMessage());
            return null;
        }
        Enumeration<?> propKeys = p.propertyNames();
        while (propKeys.hasMoreElements()) {
            String tmpKey = (String)propKeys.nextElement();
            String tmpValue = p.getProperty(tmpKey);
            if ((tmpValue = tmpValue.trim()).length() > 1 && tmpValue.startsWith("\"") && tmpValue.endsWith("\"")) {
                tmpValue = tmpValue.substring(1, tmpValue.length() - 1);
            }
            prop.put(tmpKey, tmpValue);
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Parsing string to properties: {0}size:{1}", new Object[]{prop, prop.size()});
        }
        return prop;
    }
}

