/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.core;

import jakarta.annotation.Priority;
import jakarta.enterprise.event.Event;
import jakarta.inject.Inject;
import jakarta.mvc.Controller;
import jakarta.mvc.View;
import jakarta.mvc.event.ControllerRedirectEvent;
import jakarta.mvc.event.MvcEvent;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.ServerErrorException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerResponseContext;
import jakarta.ws.rs.container.ContainerResponseFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.core.Variant;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.krazo.KrazoConfig;
import org.eclipse.krazo.cdi.KrazoCdiExtension;
import org.eclipse.krazo.core.Messages;
import org.eclipse.krazo.engine.Viewable;
import org.eclipse.krazo.event.ControllerRedirectEventImpl;
import org.eclipse.krazo.lifecycle.RequestLifecycle;
import org.eclipse.krazo.util.AnnotationUtils;
import org.eclipse.krazo.util.PathUtils;

@Controller
@Priority(value=4000)
public class ViewResponseFilter
implements ContainerResponseFilter {
    private static final Logger LOGGER = Logger.getLogger(ViewResponseFilter.class.getName());
    private static final String FILTER_EXECUTED_KEY = ViewResponseFilter.class.getName() + ".EXECUTED";
    private static final String REDIRECT = "redirect:";
    @Context
    private UriInfo uriInfo;
    @Context
    private ResourceInfo resourceInfo;
    @Inject
    private HttpServletRequest request;
    @Inject
    private Event<MvcEvent> dispatcher;
    @Inject
    private Messages messages;
    @Inject
    private KrazoConfig krazoConfig;
    @Inject
    private RequestLifecycle requestLifecycle;

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) {
        int status;
        String view;
        Class<?> entityType;
        if (this.request.getAttribute(FILTER_EXECUTED_KEY) != null) {
            return;
        }
        this.request.setAttribute(FILTER_EXECUTED_KEY, (Object)true);
        if (!this.requestLifecycle.isControllerExecuted()) {
            return;
        }
        Method method = this.requestLifecycle.getControllerMethod();
        Class<?> returnType = method.getReturnType();
        LOGGER.log(Level.FINE, "Filter response for controller: {0}#{1}", new Object[]{method.getDeclaringClass().getName(), method.getName()});
        Object entity = responseContext.getEntity();
        Class<?> clazz = entityType = entity != null ? entity.getClass() : null;
        if (entityType == null) {
            View an = AnnotationUtils.getAnnotation(method, View.class);
            if (an == null) {
                an = AnnotationUtils.getAnnotation(method.getDeclaringClass(), View.class);
            }
            if (an != null) {
                MediaType contentType = ViewResponseFilter.selectVariant(requestContext.getRequest(), this.resourceInfo);
                if (contentType == null) {
                    contentType = MediaType.TEXT_HTML_TYPE;
                }
                responseContext.setEntity((Object)new Viewable(this.appendExtensionIfRequired(an.value())), null, contentType);
                if (responseContext.getStatusInfo().getStatusCode() == Response.Status.NO_CONTENT.getStatusCode()) {
                    responseContext.setStatusInfo((Response.StatusType)Response.Status.OK);
                }
            } else if (returnType == Void.TYPE) {
                throw new ServerErrorException(this.messages.get("VoidControllerNoView", method), Response.Status.INTERNAL_SERVER_ERROR);
            }
        } else {
            view = this.appendExtensionIfRequired(entityType == Viewable.class ? ((Viewable)entity).getView() : entity.toString());
            if (view == null) {
                throw new ServerErrorException(this.messages.get("EntityToStringNull", method), Response.Status.INTERNAL_SERVER_ERROR);
            }
            responseContext.setEntity((Object)new Viewable(view), null, responseContext.getMediaType());
        }
        entity = responseContext.getEntity();
        if (entity != null) {
            view = this.appendExtensionIfRequired(((Viewable)entity).getView());
            String uri = String.valueOf(this.uriInfo.getBaseUri()) + PathUtils.noStartingSlash(PathUtils.noPrefix(view, REDIRECT));
            if (view.startsWith(REDIRECT)) {
                responseContext.setStatusInfo((Response.StatusType)Response.Status.SEE_OTHER);
                responseContext.getHeaders().putSingle((Object)"Location", (Object)uri);
                responseContext.setEntity(null);
            }
        }
        if (KrazoCdiExtension.isEventObserved(ControllerRedirectEvent.class) && ((status = responseContext.getStatus()) == Response.Status.SEE_OTHER.getStatusCode() || status == Response.Status.MOVED_PERMANENTLY.getStatusCode() || status == Response.Status.FOUND.getStatusCode() || status == Response.Status.TEMPORARY_REDIRECT.getStatusCode())) {
            ControllerRedirectEventImpl event = new ControllerRedirectEventImpl();
            event.setUriInfo(this.uriInfo);
            event.setResourceInfo(this.resourceInfo);
            event.setLocation(URI.create(responseContext.getHeaderString("Location")));
            event.setContainerRequestContext(requestContext);
            event.setContainerResponseContext(responseContext);
            this.dispatcher.fire((Object)event);
        }
    }

    private String appendExtensionIfRequired(String viewName) {
        return ViewResponseFilter.appendExtensionIfRequired(viewName, this.krazoConfig.getDefaultViewFileExtension());
    }

    static String appendExtensionIfRequired(String viewName, String defaultExtension) {
        if (viewName == null || viewName.startsWith(REDIRECT) || defaultExtension == null || defaultExtension.length() == 0 || viewName.contains(".")) {
            return viewName;
        }
        Object resultView = viewName;
        if (defaultExtension.contains(".")) {
            resultView = (String)resultView + defaultExtension;
        } else if (!viewName.contains(".")) {
            resultView = (String)resultView + "." + defaultExtension;
        }
        return resultView;
    }

    private static MediaType selectVariant(Request request, ResourceInfo resourceInfo) {
        List variants;
        Variant variant;
        Produces produces = resourceInfo.getResourceMethod().getAnnotation(Produces.class);
        if (produces == null) {
            produces = AnnotationUtils.getAnnotation(resourceInfo.getResourceClass(), Produces.class);
        }
        if (produces != null && (variant = request.selectVariant(variants = Arrays.stream(produces.value()).map(mt -> (Variant)Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.valueOf((String)mt)}).build().get(0)).collect(Collectors.toList()))) != null) {
            return variant.getMediaType();
        }
        return null;
    }
}

