/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;

public class CollectionExpression
extends ConstantExpression {
    public CollectionExpression() {
    }

    public CollectionExpression(Object newValue, Expression baseExpression) {
        super(newValue, baseExpression);
    }

    @Override
    public void printSQL(ExpressionSQLPrinter printer) {
        Object value = this.value;
        if (this.localBase != null) {
            value = this.localBase.getFieldValue(value, this.getSession());
        }
        printer.printList((Collection)value, this.canBind);
    }

    @Override
    public Object valueFromObject(Object object, AbstractSession session, AbstractRecord translationRow, int valueHolderPolicy, boolean isObjectUnregistered) {
        Object object2 = this.value;
        if (object2 instanceof Collection) {
            Collection values = (Collection)object2;
            ArrayList fieldValues = new ArrayList(values.size());
            for (Object value : values) {
                if (value instanceof Expression) {
                    Expression expression = (Expression)value;
                    value = expression.valueFromObject(object, session, translationRow, valueHolderPolicy, isObjectUnregistered);
                } else if (this.localBase != null) {
                    value = this.localBase.getFieldValue(value, session);
                }
                fieldValues.add(value);
            }
            return fieldValues;
        }
        if (this.localBase != null) {
            return this.localBase.getFieldValue(this.value, session);
        }
        return this.value;
    }

    @Override
    public void setLocalBase(Expression e) {
        super.setLocalBase(e);
        Object object = this.value;
        if (object instanceof Collection) {
            Collection values = (Collection)object;
            for (Object val : values) {
                if (!(val instanceof Expression)) continue;
                Expression expression = (Expression)val;
                expression.setLocalBase(e);
            }
        }
    }

    @Override
    protected void postCopyIn(Map<Expression, Expression> alreadyDone) {
        super.postCopyIn(alreadyDone);
        Object object = this.value;
        if (object instanceof Collection) {
            Collection values = (Collection)object;
            ArrayList<Expression> newValues = new ArrayList<Expression>(values.size());
            for (Object val : values) {
                if (val instanceof Expression) {
                    Expression expression = (Expression)val;
                    newValues.add(expression.copiedVersionFrom(alreadyDone));
                    continue;
                }
                newValues.add((Expression)val);
            }
            this.setValue(newValues);
        }
    }
}

