/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.services;

import jakarta.security.auth.message.config.AuthConfigFactory;
import jakarta.security.auth.message.config.RegistrationListener;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.glassfish.epicyro.services.ConfigData;
import org.glassfish.epicyro.services.RegistrationWrapperRemover;

public class AuthConfigRegistrationWrapper {
    private AuthConfigFactory authConfigFactory;
    private String layer;
    private String applicationContextId;
    private String authenticationProviderRegistrationId;
    private boolean enabled;
    private ConfigData data;
    private Lock wLock;
    private ReadWriteLock rwLock;
    private AuthConfigRegistrationListener listener;
    private int referenceCount = 1;
    private RegistrationWrapperRemover removerDelegate;

    public AuthConfigRegistrationWrapper(AuthConfigFactory authConfigFactory, String layer, String applicationContextId, RegistrationWrapperRemover removerDelegate) {
        this.authConfigFactory = authConfigFactory;
        this.layer = layer;
        this.applicationContextId = applicationContextId;
        this.removerDelegate = removerDelegate;
        this.rwLock = new ReentrantReadWriteLock(true);
        this.wLock = this.rwLock.writeLock();
        this.enabled = authConfigFactory != null;
        this.listener = new AuthConfigRegistrationListener(layer, applicationContextId);
    }

    public AuthConfigRegistrationListener getListener() {
        return this.listener;
    }

    public void setListener(AuthConfigRegistrationListener listener) {
        this.listener = listener;
    }

    public void disable() {
        this.wLock.lock();
        try {
            this.setEnabled(false);
        }
        finally {
            this.wLock.unlock();
            this.data = null;
        }
        if (this.authConfigFactory != null) {
            this.authConfigFactory.detachListener((RegistrationListener)this.listener, this.layer, this.applicationContextId);
            if (this.getJaspicProviderRegistrationId() != null) {
                this.authConfigFactory.removeRegistration(this.getJaspicProviderRegistrationId());
            }
        }
    }

    public void disableWithRefCount() {
        if (this.referenceCount <= 1) {
            this.disable();
            if (this.removerDelegate != null) {
                this.removerDelegate.removeListener(this);
            }
        } else {
            try {
                this.wLock.lock();
                --this.referenceCount;
            }
            finally {
                this.wLock.unlock();
            }
        }
    }

    public void incrementReference() {
        try {
            this.wLock.lock();
            ++this.referenceCount;
        }
        finally {
            this.wLock.unlock();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getJaspicProviderRegistrationId() {
        return this.authenticationProviderRegistrationId;
    }

    public void setRegistrationId(String jaspicProviderRegistrationId) {
        this.authenticationProviderRegistrationId = jaspicProviderRegistrationId;
    }

    public ConfigData getConfigData() {
        return this.data;
    }

    public void setConfigData(ConfigData data) {
        this.data = data;
    }

    public class AuthConfigRegistrationListener
    implements RegistrationListener {
        private String layer;
        private String appCtxt;

        public AuthConfigRegistrationListener(String layer, String appCtxt) {
            this.layer = layer;
            this.appCtxt = appCtxt;
        }

        public void notify(String layer, String appContext) {
            if (this.layer.equals(layer) && (this.appCtxt == null && appContext == null || appContext != null && appContext.equals(this.appCtxt))) {
                try {
                    AuthConfigRegistrationWrapper.this.wLock.lock();
                    AuthConfigRegistrationWrapper.this.data = null;
                }
                finally {
                    AuthConfigRegistrationWrapper.this.wLock.unlock();
                }
            }
        }
    }
}

