/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.page.impl;

import jakarta.data.page.Page;
import jakarta.data.page.PageRequest;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public record PageRecord<T>(PageRequest pageRequest, List<T> content, long totalElements, boolean moreResults) implements Page<T>
{
    private final long totalElements;

    public PageRecord(PageRequest pageRequest, List<T> content, long totalElements) {
        this(pageRequest, content, totalElements, content.size() == pageRequest.size() && (totalElements < 0L || totalElements > (long)pageRequest.size() * pageRequest.page()));
    }

    @Override
    public boolean hasContent() {
        return !this.content.isEmpty();
    }

    @Override
    public int numberOfElements() {
        return this.content.size();
    }

    @Override
    public boolean hasNext() {
        return this.moreResults;
    }

    @Override
    public PageRequest nextPageRequest() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return PageRequest.ofPage(this.pageRequest.page() + 1L, this.pageRequest.size(), this.pageRequest.requestTotal());
    }

    @Override
    public boolean hasPrevious() {
        return this.pageRequest.page() > 1L;
    }

    @Override
    public PageRequest previousPageRequest() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        return PageRequest.ofPage(this.pageRequest.page() - 1L, this.pageRequest.size(), this.pageRequest.requestTotal());
    }

    @Override
    public Iterator<T> iterator() {
        return this.content.iterator();
    }

    @Override
    public boolean hasTotals() {
        return this.totalElements >= 0L;
    }

    @Override
    public long totalElements() {
        if (this.totalElements < 0L) {
            throw new IllegalStateException("total elements are not available");
        }
        return this.totalElements;
    }

    @Override
    public long totalPages() {
        if (this.totalElements < 0L) {
            throw new IllegalStateException("total elements are not available");
        }
        int size = this.pageRequest.size();
        return (this.totalElements + (long)size - 1L) / (long)size;
    }
}

