/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import java.io.PrintStream;
import org.glassfish.rmic.tools.asm.Assembler;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.tree.CodeContext;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.Expression;
import org.glassfish.rmic.tools.tree.Statement;

public class InlineReturnStatement
extends Statement {
    Expression expr;

    public InlineReturnStatement(long where, Expression expr) {
        super(149, where);
        this.expr = expr;
    }

    Context getDestination(Context ctx) {
        while (ctx != null) {
            if (ctx.node != null && (ctx.node.op == 150 || ctx.node.op == 151)) {
                return ctx;
            }
            ctx = ctx.prev;
        }
        return null;
    }

    @Override
    public Statement inline(Environment env, Context ctx) {
        if (this.expr != null) {
            this.expr = this.expr.inlineValue(env, ctx);
        }
        return this;
    }

    @Override
    public Statement copyInline(Context ctx, boolean valNeeded) {
        InlineReturnStatement s = (InlineReturnStatement)this.clone();
        if (this.expr != null) {
            s.expr = this.expr.copyInline(ctx);
        }
        return s;
    }

    @Override
    public int costInline(int thresh, Environment env, Context ctx) {
        return 1 + (this.expr != null ? this.expr.costInline(thresh, env, ctx) : 0);
    }

    @Override
    public void code(Environment env, Context ctx, Assembler asm) {
        if (this.expr != null) {
            this.expr.codeValue(env, ctx, asm);
        }
        CodeContext destctx = (CodeContext)this.getDestination(ctx);
        asm.add(this.where, 167, destctx.breakLabel);
    }

    @Override
    public void print(PrintStream out, int indent) {
        super.print(out, indent);
        out.print("inline-return");
        if (this.expr != null) {
            out.print(" ");
            this.expr.print(out);
        }
        out.print(";");
    }
}

