/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jms.ra;

import com.sun.messaging.jmq.jmsservice.Destination;
import com.sun.messaging.jmq.jmsservice.JMSService;
import com.sun.messaging.jmq.jmsservice.JMSServiceException;
import com.sun.messaging.jms.ra.DirectPacket;
import com.sun.messaging.jms.ra.DirectSession;
import jakarta.jms.CompletionListener;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueSender;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.Topic;
import jakarta.jms.TopicPublisher;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DirectProducer
implements QueueSender,
TopicPublisher {
    private JMSService jmsservice;
    private DirectSession ds;
    private long connectionId;
    private long sessionId;
    private long producerId = 0L;
    private JMSService.MessageDeliveryMode deliveryMode;
    private int jmsDeliveryMode = 2;
    private JMSService.MessagePriority priority;
    private int jmsPriority = 4;
    private long jmsTimeToLive = 0L;
    private long jmsDeliveryDelay = 0L;
    private jakarta.jms.Destination destination = null;
    private Destination jmsservice_destination;
    private boolean disableMessageID = false;
    private boolean disableMessageTimestamp = false;
    private boolean isClosed;
    private HashMap<String, Long> producerIds;
    protected int _logLevel;
    protected boolean _logFINE = false;
    private static final String _className = "com.sun.messaging.jms.ra.DirectProducer";
    private static final String _lgrNameOutboundConnection = "javax.resourceadapter.mqjmsra.outbound.connection";
    private static final String _lgrNameJMSProducer = "jakarta.jms.MessageProducer.mqjmsra";
    private static final Logger _loggerOC = Logger.getLogger("javax.resourceadapter.mqjmsra.outbound.connection");
    private static final Logger _loggerJMP = Logger.getLogger("jakarta.jms.MessageProducer.mqjmsra");
    private static final String _lgrMIDPrefix = "MQJMSRA_DMP";
    private static final String _lgrMID_INF = "MQJMSRA_DMP1101: ";
    private static final String _lgrMID_WRN = "MQJMSRA_DMP2001: ";
    private static final String _lgrMID_EXC = "MQJMSRA_DMP4001: ";

    public DirectProducer(DirectSession ds, JMSService jmsservice) {
        Object[] params = new Object[]{ds, jmsservice};
        _loggerOC.entering(_className, "constructor()", params);
        this.ds = ds;
        this.jmsservice = jmsservice;
        this.connectionId = ds.getConnectionId();
        this.sessionId = ds.getSessionId();
        this.producerIds = new HashMap();
    }

    public DirectProducer(DirectSession ds, JMSService jmsservice, long producerId, jakarta.jms.Destination destination, Destination jmsservice_dest) {
        Object[] params = new Object[]{ds, jmsservice, producerId, destination, jmsservice_dest};
        _loggerOC.entering(_className, "constructor()", params);
        this.ds = ds;
        this.jmsservice = jmsservice;
        this.producerId = producerId;
        this.destination = destination;
        if (this.destination == null) {
            this.producerIds = new HashMap();
        }
        this.jmsservice_destination = jmsservice_dest;
        this.connectionId = ds.getConnectionId();
        this.sessionId = ds.getSessionId();
        Level _level = _loggerJMP.getLevel();
        if (_level != null) {
            this._logLevel = _level.intValue();
            if (this._logLevel <= Level.FINE.intValue()) {
                this._logFINE = true;
            }
        }
    }

    public synchronized void close() throws JMSException {
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":close():");
        if (this.isClosed) {
            return;
        }
        this.ds.removeProducer(this);
        this._close();
    }

    public int getDeliveryMode() throws JMSException {
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":getDeliveryMode():" + String.valueOf((Object)this.deliveryMode));
        this._checkIfClosed("getDeliveryMode()");
        return this.jmsDeliveryMode;
    }

    public jakarta.jms.Destination getDestination() throws JMSException {
        String methodName = "getDestination()";
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + methodName + (this.jmsservice_destination == null ? null : this.jmsservice_destination.toString()));
        this._checkIfClosed("getDestination()");
        return this.destination;
    }

    public boolean getDisableMessageID() throws JMSException {
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":getDisableMessageID():" + this.disableMessageID);
        this._checkIfClosed("getDisableMessageID()");
        return this.disableMessageID;
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":getDisableMessageTimestamp():" + this.disableMessageTimestamp);
        this._checkIfClosed("getDisableMessageTimestamp()");
        return this.disableMessageTimestamp;
    }

    public int getPriority() throws JMSException {
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":getPriority():" + String.valueOf((Object)this.priority));
        this._checkIfClosed("getPriority()");
        return this.jmsPriority;
    }

    public long getTimeToLive() throws JMSException {
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":getTimeToLive():" + this.jmsTimeToLive);
        this._checkIfClosed("getTimeToLive()");
        return this.jmsTimeToLive;
    }

    public void send(jakarta.jms.Destination destination, Message message) throws JMSException {
        String methodName = "send(Destination, Message)";
        if (this._logFINE) {
            _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + methodName);
        }
        this._checkIfClosed(methodName);
        this._checkDestinationParam(methodName, destination);
        this._createAndAddProducerId(destination);
        this._send(destination, message, this.jmsDeliveryMode, this.jmsPriority, this.jmsTimeToLive);
    }

    public void send(jakarta.jms.Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        String methodName = "send(Destination, Message, deliveryMode, priority, timeToLive)";
        if (this._logFINE) {
            _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + methodName);
        }
        this._checkIfClosed(methodName);
        this._checkDestinationParam(methodName, destination);
        this._createAndAddProducerId(destination);
        this._send(destination, message, deliveryMode, priority, timeToLive);
    }

    public void send(Message message) throws JMSException {
        String methodName = "send(Message)";
        if (this._logFINE) {
            _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + methodName);
        }
        this._checkIfClosed(methodName);
        this._checkForUnsupportedOperation(methodName, null, true);
        this._send(this.destination, message, this.jmsDeliveryMode, this.jmsPriority, this.jmsTimeToLive);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        String methodName = "send(Message, deliveryMode, priority, timeToLive)";
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + methodName);
        this._checkIfClosed(methodName);
        this._checkForUnsupportedOperation(methodName, null, true);
        this._send(this.destination, message, deliveryMode, priority, timeToLive);
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":setDeliveryMode():" + deliveryMode);
        this._checkIfClosed("getDeliveryMode()");
        switch (deliveryMode) {
            case 2: {
                this.deliveryMode = JMSService.MessageDeliveryMode.PERSISTENT;
                this.jmsDeliveryMode = 2;
                break;
            }
            case 1: {
                this.deliveryMode = JMSService.MessageDeliveryMode.NON_PERSISTENT;
                this.jmsDeliveryMode = 1;
                break;
            }
            default: {
                String excMsg = "MQJMSRA_DMP4001: setDeliveryMode():Invalid deliveryMode=" + deliveryMode;
                _loggerJMP.warning(excMsg);
                throw new JMSException(excMsg);
            }
        }
    }

    public void setDisableMessageID(boolean disableMessageID) throws JMSException {
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":setDisableMessageID():" + disableMessageID);
        this._checkIfClosed("setDisableMessageID()");
        this.disableMessageID = disableMessageID;
    }

    public void setDisableMessageTimestamp(boolean disableMessageTimestamp) throws JMSException {
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":setDisableMessageTimestamp():" + disableMessageTimestamp);
        this._checkIfClosed("setDisableMessageTimestamp()");
        this.disableMessageTimestamp = disableMessageTimestamp;
    }

    public void setPriority(int priority) throws JMSException {
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":setPriority():" + priority);
        this._checkIfClosed("setPriority()");
        switch (priority) {
            case 0: {
                this.priority = JMSService.MessagePriority.PRIORITY_0;
                break;
            }
            case 1: {
                this.priority = JMSService.MessagePriority.PRIORITY_1;
                break;
            }
            case 2: {
                this.priority = JMSService.MessagePriority.PRIORITY_2;
                break;
            }
            case 3: {
                this.priority = JMSService.MessagePriority.PRIORITY_3;
                break;
            }
            case 4: {
                this.priority = JMSService.MessagePriority.PRIORITY_4;
                break;
            }
            case 5: {
                this.priority = JMSService.MessagePriority.PRIORITY_5;
                break;
            }
            case 6: {
                this.priority = JMSService.MessagePriority.PRIORITY_6;
                break;
            }
            case 7: {
                this.priority = JMSService.MessagePriority.PRIORITY_7;
                break;
            }
            case 8: {
                this.priority = JMSService.MessagePriority.PRIORITY_8;
                break;
            }
            case 9: {
                this.priority = JMSService.MessagePriority.PRIORITY_9;
                break;
            }
            default: {
                String excMsg = "MQJMSRA_DMP4001: setPriority():Invalid to set priority outside (0-9):value=" + priority;
                _loggerJMP.warning(excMsg);
                throw new JMSException(excMsg);
            }
        }
        this.jmsPriority = priority;
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":setTimeToLive():" + timeToLive);
        this._checkIfClosed("setTimeToLive()" + timeToLive);
        if (timeToLive < 0L) {
            String excMsg = "MQJMSRA_DMP4001: setTimeToLive():Invalid to set timeToLive as negative:value=" + timeToLive;
            _loggerJMP.warning(excMsg);
            throw new JMSException(excMsg);
        }
        this.jmsTimeToLive = timeToLive;
    }

    public void setDeliveryDelay(long deliveryDelay) throws JMSException {
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":setDeliveryDelay():" + deliveryDelay);
        this._checkIfClosed("setDeliveryDelay()" + deliveryDelay);
        if (deliveryDelay < 0L) {
            String excMsg = "MQJMSRA_DMP4001: setDeliveryDelay():Invalid to set deliveryDelay as negative:value=" + deliveryDelay;
            _loggerJMP.warning(excMsg);
            throw new JMSException(excMsg);
        }
        this.jmsDeliveryDelay = deliveryDelay;
    }

    public long getDeliveryDelay() throws JMSException {
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":getDeliveryDelay():" + this.jmsDeliveryDelay);
        this._checkIfClosed("getDeliveryDelay()");
        return this.jmsDeliveryDelay;
    }

    public Queue getQueue() throws JMSException {
        String methodName = "getQueue()";
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + methodName);
        this._checkIfClosed(methodName);
        if (this.destination == null) {
            return null;
        }
        if (this.destination instanceof Queue) {
            return (Queue)this.destination;
        }
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + methodName + " called on Destination:" + String.valueOf(this.destination));
        return null;
    }

    public void send(Queue queue, Message message) throws JMSException {
        String methodName = "send(Queue, Message)";
        if (this._logFINE) {
            _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + methodName);
        }
        this._checkIfClosed(methodName);
        this._checkDestinationParam(methodName, (jakarta.jms.Destination)queue);
        this._createAndAddProducerId((jakarta.jms.Destination)queue);
        this._send((jakarta.jms.Destination)queue, message, this.jmsDeliveryMode, this.jmsPriority, this.jmsTimeToLive);
    }

    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        String methodName = "send(Queue, Message, deliveryMode, priority, timeToLive)";
        if (this._logFINE) {
            _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + methodName);
        }
        this._checkIfClosed(methodName);
        this._checkDestinationParam(methodName, (jakarta.jms.Destination)queue);
        this._createAndAddProducerId((jakarta.jms.Destination)queue);
        this._send((jakarta.jms.Destination)queue, message, deliveryMode, priority, timeToLive);
    }

    public Topic getTopic() throws JMSException {
        String methodName = "getTopic()";
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + methodName);
        this._checkIfClosed(methodName);
        if (this.destination == null) {
            return null;
        }
        if (this.destination instanceof Topic) {
            return (Topic)this.destination;
        }
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + methodName + " called on Destination:" + String.valueOf(this.destination));
        return null;
    }

    public void publish(Message message) throws JMSException {
        String methodName = "publish(Message)";
        _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + methodName);
        this._checkIfClosed(methodName);
        this._checkForUnsupportedOperation(methodName, null, true);
        this._send(this.destination, message, this.jmsDeliveryMode, this.jmsPriority, this.jmsTimeToLive);
    }

    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        String methodName = "publish(Message, deliveryMode, priority, timeToLive)";
        if (this._logFINE) {
            _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + methodName);
        }
        this._checkIfClosed(methodName);
        this._checkForUnsupportedOperation(methodName, null, true);
        this._send(this.destination, message, deliveryMode, priority, timeToLive);
    }

    public void publish(Topic topic, Message message) throws JMSException {
        String methodName = "publish(Topic, Message)";
        if (this._logFINE) {
            _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + methodName);
        }
        this._checkIfClosed(methodName);
        this._checkDestinationParam(methodName, (jakarta.jms.Destination)topic);
        this._createAndAddProducerId((jakarta.jms.Destination)topic);
        this._send((jakarta.jms.Destination)topic, message, this.jmsDeliveryMode, this.jmsPriority, this.jmsTimeToLive);
    }

    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        String methodName = "publish(Topic, Message, deliveryMode, priority, timeToLive)";
        if (this._logFINE) {
            _loggerJMP.fine("MQJMSRA_DMP1101: producerId=" + this.producerId + ":" + methodName);
        }
        this._checkIfClosed(methodName);
        this._checkDestinationParam(methodName, (jakarta.jms.Destination)topic);
        this._createAndAddProducerId((jakarta.jms.Destination)topic);
        this._send((jakarta.jms.Destination)topic, message, deliveryMode, priority, timeToLive);
    }

    public long getConnectionId() {
        return this.connectionId;
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public long getProducerId() {
        return this.producerId;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    private void _checkIfClosed(String methodname) throws JMSException {
        if (this.isClosed()) {
            String closedmsg = _lgrMID_EXC + methodname + "MessageProducer is closed:Id=" + this.producerId;
            _loggerJMP.warning(closedmsg);
            throw new IllegalStateException(closedmsg);
        }
    }

    private void _createAndAddProducerId(jakarta.jms.Destination destination) throws JMSException {
        String _name = null;
        Object dName = null;
        Destination.Type _type = Destination.Type.QUEUE;
        Destination.Life _life = Destination.Life.STANDARD;
        if (destination instanceof Queue) {
            _name = ((Queue)destination).getQueueName();
            _type = Destination.Type.QUEUE;
            if (destination instanceof TemporaryQueue) {
                _life = Destination.Life.TEMPORARY;
                dName = _name;
            } else {
                dName = String.valueOf((Object)_type) + _name;
            }
        }
        if (destination instanceof Topic) {
            _name = ((Topic)destination).getTopicName();
            _type = Destination.Type.TOPIC;
            if (destination instanceof TemporaryTopic) {
                _life = Destination.Life.TEMPORARY;
                dName = _name;
            } else {
                dName = String.valueOf((Object)_type) + ":" + _name;
            }
        }
        Destination _destination = new Destination(_name, _type, _life);
        this.ds.getConnection()._createDestination(_destination);
        if (!this.producerIds.containsKey(dName)) {
            long producerId = this.ds._createProducerId(_destination);
            this.producerIds.put((String)dName, producerId);
        }
    }

    private void _checkDestinationParam(String methodname, jakarta.jms.Destination dest) throws JMSException {
        if (dest == null) {
            String nullDestMsg = _lgrMID_EXC + methodname + ":Null Destination used:";
            _loggerJMP.warning(nullDestMsg);
            throw new InvalidDestinationException(nullDestMsg, _lgrMID_EXC);
        }
        this._checkForUnsupportedOperation(methodname, dest, false);
    }

    private void _checkForUnsupportedOperation(String methodname, jakarta.jms.Destination dest, boolean mpDest_Required) {
        if (!mpDest_Required) {
            if (this.destination != null) {
                String dest_name = null;
                try {
                    dest_name = dest instanceof Queue ? ((Queue)dest).getQueueName() : ((Topic)dest).getTopicName();
                }
                catch (JMSException ex) {
                    dest_name = "null";
                }
                String nonNullDestMsg = _lgrMID_EXC + methodname + ":Unsupported Operation:Producing to destination:" + dest_name + ":in MessageProducer with specified Destination";
                if (this.jmsservice_destination != null) {
                    nonNullDestMsg = nonNullDestMsg + "=" + String.valueOf((Object)this.jmsservice_destination.getType()) + ":" + this.jmsservice_destination.getName();
                }
                _loggerJMP.warning(nonNullDestMsg);
                throw new UnsupportedOperationException(nonNullDestMsg);
            }
        } else if (this.destination == null) {
            String nullDestMsg = _lgrMID_EXC + methodname + ":Unsupported Operation:Producing destination not specified (null) in MessageProducer with unspecified Destination";
            _loggerJMP.warning(nullDestMsg);
            throw new UnsupportedOperationException(nullDestMsg);
        }
    }

    private void _send(jakarta.jms.Destination destination, Message msg, int deliveryMode, int priority, long timeToLive) throws JMSException {
        DirectPacket dPkt = null;
        boolean foreignMessageConverted = false;
        if (msg instanceof DirectPacket) {
            dPkt = (DirectPacket)msg;
        } else {
            dPkt = DirectPacket.constructFromForeignMessage(this.jmsservice, this.ds, msg);
            foreignMessageConverted = true;
        }
        assert (dPkt != null);
        dPkt.setJMSDestination(destination);
        dPkt.setJMSDeliveryMode(deliveryMode);
        dPkt.setJMSPriority(priority);
        dPkt.setJMSExpiration(timeToLive);
        dPkt.setJMSDeliveryTime(this.jmsDeliveryDelay);
        dPkt.preparePacketForSend();
        DirectPacket msgPkt = dPkt;
        this.ds._sendMessage(msgPkt);
        if (foreignMessageConverted) {
            DirectPacket.updateForeignMessageAfterSend(dPkt, msg);
        }
    }

    protected synchronized void _close() throws JMSException {
        block7: {
            if (this.isClosed) {
                return;
            }
            try {
                if (this.destination != null) {
                    this.jmsservice.deleteProducer(this.connectionId, this.sessionId, this.producerId);
                    break block7;
                }
                String dName = null;
                Iterator<String> k = this.producerIds.keySet().iterator();
                while (k.hasNext()) {
                    dName = k.next();
                    long t_producerId = this.producerIds.get(dName);
                    try {
                        this.jmsservice.deleteProducer(this.connectionId, this.sessionId, t_producerId);
                    }
                    catch (JMSServiceException jmssel) {
                        _loggerJMP.warning("MQJMSRA_DMP2001: producerId=" + t_producerId + ":close():JMSService.deleteProducer():Destination=:" + dName + ":JMSServiceException=" + jmssel.getMessage());
                    }
                    k.remove();
                }
                this.producerIds.clear();
            }
            catch (JMSServiceException jmsse) {
                _loggerJMP.warning("MQJMSRA_DMP2001: producerId=" + this.producerId + ":close():JMSService.deleteProducer():Destination=:" + String.valueOf(this.destination) + ":JMSServiceException=" + jmsse.getMessage());
            }
        }
        this.isClosed = true;
    }

    public void send(Message message, CompletionListener completionListener) throws JMSException {
        throw new JMSException("MQJMSRA_DMP4001: Method send(Message, CompletionListener) is not allowed");
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        throw new JMSException("MQJMSRA_DMP4001: Method send(Message, int, int, long, CompletionListener) is not allowed");
    }

    public void send(jakarta.jms.Destination destination, Message message, CompletionListener completionListener) throws JMSException {
        throw new JMSException("MQJMSRA_DMP4001: Method send(Destination, Message, CompletionListener) is not allowed");
    }

    public void send(jakarta.jms.Destination destination, Message message, int deliveryMode, int priority, long timeToLive, CompletionListener completionListener) throws JMSException {
        throw new JMSException("MQJMSRA_DMP4001: Method send(Destination, Message, int, int, long, CompletionListener) is not allowed");
    }
}

