/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.faces;

import com.sun.data.provider.DataProvider;
import com.sun.data.provider.DataProviderException;
import com.sun.data.provider.FieldKey;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.TableCursorVetoException;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.TableRowDataProvider;
import com.sun.faces.annotation.Resolver;
import com.sun.webui.jsf.model.Option;
import com.sun.webui.jsf.util.LogUtil;
import jakarta.el.ELContext;
import jakarta.el.ELResolver;
import jakarta.el.PropertyNotFoundException;
import jakarta.faces.model.SelectItem;
import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

@Resolver
public final class DataProviderELResolver
extends ELResolver {
    public static final String VALUE_KEY = "value";
    public static final String SELECT_ITEMS_KEY = "selectItems";
    public static final String OPTIONS_KEY = "options";
    public static final String STRING_LIST_KEY = "stringList";
    public static final String ROWID_FKEY = ":ROWID:";
    public static final String ROWKEY_FKEY = ":ROWKEY:";

    public Object getValue(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof DataProvider) {
            DataProvider provider = (DataProvider)base;
            if (VALUE_KEY.equals(property)) {
                ValueData result = new ValueData(provider);
                context.setPropertyResolved(true);
                return result;
            }
            if (SELECT_ITEMS_KEY.equals(property)) {
                SelectItemsData result = new SelectItemsData(provider);
                context.setPropertyResolved(true);
                return result;
            }
            if (OPTIONS_KEY.equals(property)) {
                OptionsData result = new OptionsData(provider);
                context.setPropertyResolved(true);
                return result;
            }
            if (STRING_LIST_KEY.equals(property)) {
                StringListData result = new StringListData(provider);
                context.setPropertyResolved(true);
                return result;
            }
        } else {
            if (base instanceof ValueData) {
                Object result = ((ValueData)base).getValue(property.toString());
                context.setPropertyResolved(true);
                return result;
            }
            if (base instanceof SelectItemsData) {
                Object result = ((SelectItemsData)base).getSelectItems(property.toString());
                context.setPropertyResolved(true);
                return result;
            }
        }
        return null;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof ValueData) {
            ((ValueData)base).setValue("" + property, value);
            context.setPropertyResolved(true);
        }
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof ValueData) {
            boolean result = ((ValueData)base).isReadOnly("" + property);
            context.setPropertyResolved(true);
            return result;
        }
        if (base instanceof SelectItemsData) {
            context.setPropertyResolved(true);
            return true;
        }
        if (base instanceof DataProvider) {
            if (VALUE_KEY.equals(property)) {
                context.setPropertyResolved(true);
                return true;
            }
            if (SELECT_ITEMS_KEY.equals(property) || OPTIONS_KEY.equals(property) || STRING_LIST_KEY.equals(property)) {
                context.setPropertyResolved(true);
                return true;
            }
        }
        return false;
    }

    public Class getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof DataProvider) {
            if (VALUE_KEY.equals(property)) {
                context.setPropertyResolved(true);
                return ValueData.class;
            }
            if (SELECT_ITEMS_KEY.equals(property)) {
                context.setPropertyResolved(true);
                return SelectItemsData.class;
            }
            if (OPTIONS_KEY.equals(property)) {
                context.setPropertyResolved(true);
                return OptionsData.class;
            }
            if (STRING_LIST_KEY.equals(property)) {
                context.setPropertyResolved(true);
                return StringListData.class;
            }
        } else {
            if (base instanceof ValueData) {
                Class result = ((ValueData)base).getType("" + property);
                context.setPropertyResolved(true);
                return result;
            }
            if (base instanceof SelectItemsData) {
                context.setPropertyResolved(true);
                return ArrayList.class;
            }
        }
        return null;
    }

    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null) {
            return Arrays.asList(new FeatureDescriptor[0]).iterator();
        }
        ArrayList<FeatureDescriptor> result = new ArrayList<FeatureDescriptor>();
        if (base instanceof DataProvider) {
            String[] exposedKeys;
            for (String exposedKey : exposedKeys = new String[]{VALUE_KEY, SELECT_ITEMS_KEY, OPTIONS_KEY}) {
                FeatureDescriptor desc = new FeatureDescriptor();
                desc.setName(exposedKey);
                desc.setDisplayName(exposedKey);
                desc.setValue("type", String.class);
                desc.setValue("resolvableAtDesignTime", true);
                result.add(desc);
            }
        } else if (base instanceof ValueData) {
            DataProvider provider = ((ValueData)base).getProvider();
            FieldKey[] fieldKeys = provider.getFieldKeys();
            if (fieldKeys != null) {
                for (FieldKey fieldKey : fieldKeys) {
                    FeatureDescriptor desc = new FeatureDescriptor();
                    String fieldId = fieldKey.getFieldId();
                    String displayName = fieldKey.getDisplayName();
                    if (displayName == null) {
                        displayName = fieldId;
                    }
                    if (fieldId == null) continue;
                    desc.setName(fieldId);
                    desc.setDisplayName(displayName);
                    desc.setValue("type", Object.class);
                    desc.setValue("resolvableAtDesignTime", true);
                    result.add(desc);
                }
            }
        } else if (base instanceof SelectItemsData) {
            return null;
        }
        return result.iterator();
    }

    public Class getCommonPropertyType(ELContext context, Object base) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base instanceof DataProvider) {
            return String.class;
        }
        if (base instanceof ValueData || base instanceof SelectItemsData) {
            return Object.class;
        }
        return null;
    }

    private final class StringListData
    extends SelectItemsData {
        StringListData(DataProvider provider) {
            super(provider);
        }

        @Override
        protected Object getSelectItem(Object itemValue, Object itemLabel, Object itemDescr) {
            if (itemValue != null) {
                return itemValue.toString();
            }
            return "";
        }
    }

    private final class OptionsData
    extends SelectItemsData {
        OptionsData(DataProvider provider) {
            super(provider);
        }

        @Override
        protected Object getSelectItem(Object itemValue, Object itemLabel, Object itemDescr) {
            if (itemValue != null && itemLabel != null && itemDescr != null) {
                return new Option(itemValue, itemLabel.toString(), itemDescr.toString());
            }
            if (itemValue != null && itemLabel != null) {
                return new Option(itemValue, itemLabel.toString());
            }
            if (itemValue != null) {
                return new Option(itemValue);
            }
            return null;
        }
    }

    private class SelectItemsData {
        private final DataProvider provider;

        SelectItemsData(DataProvider newProvider) {
            this.provider = newProvider;
        }

        protected final Object getValue(DataProvider dataProvider, String fieldId, RowKey row) {
            if (fieldId == null) {
                return null;
            }
            Object value = null;
            if (DataProviderELResolver.ROWKEY_FKEY.equals(fieldId)) {
                value = row != null ? row : (dataProvider instanceof TableRowDataProvider ? ((TableRowDataProvider)dataProvider).getTableRow() : null);
            } else if (DataProviderELResolver.ROWID_FKEY.equals(fieldId)) {
                value = row != null ? row.getRowId() : (dataProvider instanceof TableRowDataProvider ? ((TableRowDataProvider)dataProvider).getTableRow().getRowId() : null);
            } else {
                FieldKey fk = dataProvider.getFieldKey(fieldId);
                if (fk != null) {
                    value = row != null && dataProvider instanceof TableDataProvider ? ((TableDataProvider)dataProvider).getValue(fk, row) : dataProvider.getValue(fk);
                }
            }
            return value;
        }

        protected Object getSelectItem(Object itemValue, Object itemLabel, Object itemDescr) {
            if (itemValue != null && itemLabel != null && itemDescr != null) {
                return new SelectItem(itemValue, itemLabel.toString(), itemDescr.toString());
            }
            if (itemValue != null && itemLabel != null) {
                return new SelectItem(itemValue, itemLabel.toString());
            }
            if (itemValue != null) {
                return new SelectItem(itemValue);
            }
            return null;
        }

        public final Object getSelectItems(String columns) {
            String[] args;
            String col;
            String labelId = null;
            String descrId = null;
            ArrayList<String> cols = new ArrayList<String>();
            boolean quoteOpen = false;
            int currStart = 0;
            for (int i = 0; i < columns.length(); ++i) {
                char c = columns.charAt(i);
                if (c == '\'') {
                    quoteOpen = !quoteOpen;
                    continue;
                }
                if (c != ',' || quoteOpen) continue;
                col = columns.substring(currStart, i);
                if (col.length() > 0) {
                    cols.add(col);
                }
                currStart = i + 1;
            }
            if (currStart < columns.length()) {
                col = columns.substring(currStart);
                cols.add(col);
            }
            if ((args = cols.toArray(new String[cols.size()])).length < 1) {
                throw new IllegalArgumentException();
            }
            String valueId = args[0];
            if (args.length > 1) {
                labelId = args[1];
            }
            if (args.length > 2) {
                descrId = args[2];
            }
            ArrayList<Object> list = new ArrayList<Object>();
            if (this.provider instanceof TableDataProvider) {
                RowKey[] rows;
                TableDataProvider tableProvider = (TableDataProvider)this.provider;
                int rowCount = tableProvider.getRowCount();
                if (rowCount < 0) {
                    rowCount = 999;
                }
                for (RowKey row : rows = tableProvider.getRowKeys(rowCount, null)) {
                    Object itemDescr;
                    Object itemLabel;
                    Object itemValue = this.getValue(this.provider, valueId, row);
                    Object selectItem = this.getSelectItem(itemValue, itemLabel = this.getValue(this.provider, labelId, row), itemDescr = this.getValue(this.provider, descrId, row));
                    if (selectItem == null) continue;
                    list.add(selectItem);
                }
            } else {
                Object itemDescr;
                Object itemLabel;
                Object itemValue = this.getValue(this.provider, valueId, null);
                Object selectItem = this.getSelectItem(itemValue, itemLabel = this.getValue(this.provider, labelId, null), itemDescr = this.getValue(this.provider, descrId, null));
                if (selectItem != null) {
                    list.add(selectItem);
                }
            }
            return list;
        }
    }

    private final class ValueData {
        private final DataProvider provider;

        ValueData(DataProvider newProvider) {
            this.provider = newProvider;
        }

        public DataProvider getProvider() {
            return this.provider;
        }

        public Object getValue(String fieldId) throws PropertyNotFoundException {
            Object value;
            block15: {
                if (fieldId == null) {
                    return null;
                }
                value = null;
                if (DataProviderELResolver.ROWKEY_FKEY.equals(fieldId)) {
                    if (this.provider instanceof TableDataProvider) {
                        return ((TableDataProvider)this.provider).getCursorRow();
                    }
                    if (this.provider instanceof TableRowDataProvider) {
                        return ((TableRowDataProvider)this.provider).getTableRow();
                    }
                } else if (DataProviderELResolver.ROWID_FKEY.equals(fieldId)) {
                    if (this.provider instanceof TableDataProvider) {
                        return ((TableDataProvider)this.provider).getCursorRow().getRowId();
                    }
                    if (this.provider instanceof TableRowDataProvider) {
                        return ((TableRowDataProvider)this.provider).getTableRow().getRowId();
                    }
                } else {
                    try {
                        FieldKey fk = this.provider.getFieldKey(fieldId);
                        if (fk != null) {
                            try {
                                value = this.provider.getValue(fk);
                            }
                            catch (IndexOutOfBoundsException e) {
                                value = null;
                            }
                            break block15;
                        }
                        throw new PropertyNotFoundException("Field '" + fieldId + "' not found in DataProvider.");
                    }
                    catch (DataProviderException x) {
                        throw new PropertyNotFoundException((Throwable)x);
                    }
                    catch (PropertyNotFoundException x) {
                        throw new PropertyNotFoundException((Throwable)x);
                    }
                }
            }
            return value;
        }

        public void setValue(String fieldId, Object value) throws PropertyNotFoundException {
            block23: {
                if (fieldId == null) {
                    return;
                }
                if (DataProviderELResolver.ROWKEY_FKEY.equals(fieldId) && value instanceof RowKey) {
                    if (this.provider instanceof TableDataProvider) {
                        try {
                            ((TableDataProvider)this.provider).setCursorRow((RowKey)value);
                            return;
                        }
                        catch (TableCursorVetoException ex) {
                            LogUtil.severe(null, ex);
                        }
                    }
                    if (this.provider instanceof TableRowDataProvider) {
                        try {
                            ((TableRowDataProvider)this.provider).setTableRow((RowKey)value);
                        }
                        catch (Exception ex) {
                            LogUtil.severe(null, ex);
                        }
                    }
                } else if (DataProviderELResolver.ROWID_FKEY.equals(fieldId) && value instanceof String) {
                    if (this.provider instanceof TableDataProvider) {
                        try {
                            RowKey row = ((TableDataProvider)this.provider).getRowKey((String)value);
                            ((TableDataProvider)this.provider).setCursorRow(row);
                            return;
                        }
                        catch (DataProviderException ex) {
                            LogUtil.severe(null, ex);
                        }
                    }
                    if (this.provider instanceof TableRowDataProvider) {
                        try {
                            RowKey row = ((TableRowDataProvider)this.provider).getTableDataProvider().getRowKey((String)value);
                            ((TableRowDataProvider)this.provider).setTableRow(row);
                        }
                        catch (DataProviderException ex) {
                            LogUtil.severe(null, ex);
                        }
                    }
                } else {
                    try {
                        FieldKey fk = this.provider.getFieldKey(fieldId);
                        if (fk != null) {
                            try {
                                this.provider.setValue(fk, value);
                            }
                            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
                            break block23;
                        }
                        throw new PropertyNotFoundException("Field '" + fieldId + "' not found in DataProvider.");
                    }
                    catch (DataProviderException x) {
                        throw new PropertyNotFoundException((Throwable)x);
                    }
                    catch (PropertyNotFoundException x) {
                        throw new PropertyNotFoundException((Throwable)x);
                    }
                }
            }
        }

        public boolean isReadOnly(String fieldId) throws PropertyNotFoundException {
            if (DataProviderELResolver.ROWKEY_FKEY.equals(fieldId) || DataProviderELResolver.ROWID_FKEY.equals(fieldId)) {
                return false;
            }
            try {
                FieldKey fk = this.provider.getFieldKey(fieldId);
                if (fk != null) {
                    return this.provider.isReadOnly(fk);
                }
                throw new PropertyNotFoundException("Field '" + fieldId + "' not found in DataProvider.");
            }
            catch (DataProviderException x) {
                throw new PropertyNotFoundException((Throwable)x);
            }
            catch (PropertyNotFoundException x) {
                throw new PropertyNotFoundException((Throwable)x);
            }
        }

        public Class getType(String fieldId) throws PropertyNotFoundException {
            if (DataProviderELResolver.ROWKEY_FKEY.equals(fieldId)) {
                return RowKey.class;
            }
            if (DataProviderELResolver.ROWID_FKEY.equals(fieldId)) {
                return String.class;
            }
            try {
                FieldKey fk = this.provider.getFieldKey(fieldId);
                if (fk != null) {
                    return this.provider.getType(fk);
                }
                throw new PropertyNotFoundException("Field '" + fieldId + "' not found in DataProvider.");
            }
            catch (DataProviderException x) {
                throw new PropertyNotFoundException((Throwable)x);
            }
            catch (PropertyNotFoundException x) {
                throw new PropertyNotFoundException((Throwable)x);
            }
        }
    }
}

