/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http;

import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.http.KeepAliveProbe;
import org.glassfish.grizzly.monitoring.DefaultMonitoringConfig;
import org.glassfish.grizzly.monitoring.MonitoringAware;
import org.glassfish.grizzly.monitoring.MonitoringConfig;
import org.glassfish.grizzly.monitoring.MonitoringUtils;

public final class KeepAlive
implements MonitoringAware<KeepAliveProbe> {
    protected final DefaultMonitoringConfig<KeepAliveProbe> monitoringConfig;
    private int idleTimeoutInSeconds = 30;
    private int maxRequestsCount = 256;

    public KeepAlive() {
        this.monitoringConfig = new DefaultMonitoringConfig<KeepAliveProbe>(KeepAliveProbe.class){

            @Override
            public Object createManagementObject() {
                return KeepAlive.this.createJmxManagementObject();
            }
        };
    }

    public KeepAlive(KeepAlive keepAlive) {
        this.monitoringConfig = keepAlive.monitoringConfig;
        this.idleTimeoutInSeconds = keepAlive.idleTimeoutInSeconds;
        this.maxRequestsCount = keepAlive.maxRequestsCount;
    }

    public int getIdleTimeoutInSeconds() {
        return this.idleTimeoutInSeconds;
    }

    public void setIdleTimeoutInSeconds(int idleTimeoutInSeconds) {
        this.idleTimeoutInSeconds = idleTimeoutInSeconds < 0 ? -1 : idleTimeoutInSeconds;
    }

    public int getMaxRequestsCount() {
        return this.maxRequestsCount;
    }

    public void setMaxRequestsCount(int maxRequestsCount) {
        this.maxRequestsCount = maxRequestsCount;
    }

    @Override
    public MonitoringConfig<KeepAliveProbe> getMonitoringConfig() {
        return this.monitoringConfig;
    }

    protected Object createJmxManagementObject() {
        return MonitoringUtils.loadJmxObject("org.glassfish.grizzly.http.jmx.KeepAlive", this, KeepAlive.class);
    }

    protected static void notifyProbesConnectionAccepted(KeepAlive keepAlive, Connection connection) {
        KeepAliveProbe[] probes = keepAlive.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (KeepAliveProbe probe : probes) {
                probe.onConnectionAcceptEvent(connection);
            }
        }
    }

    protected static void notifyProbesHit(KeepAlive keepAlive, Connection connection, int requestNumber) {
        KeepAliveProbe[] probes = keepAlive.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (KeepAliveProbe probe : probes) {
                probe.onHitEvent(connection, requestNumber);
            }
        }
    }

    protected static void notifyProbesRefused(KeepAlive keepAlive, Connection connection) {
        KeepAliveProbe[] probes = keepAlive.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (KeepAliveProbe probe : probes) {
                probe.onRefuseEvent(connection);
            }
        }
    }

    protected static void notifyProbesTimeout(KeepAlive keepAlive, Connection connection) {
        KeepAliveProbe[] probes = keepAlive.monitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (KeepAliveProbe probe : probes) {
                probe.onTimeoutEvent(connection);
            }
        }
    }
}

