/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.se;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.security.GetDeclaredConstructorAction;
import org.jboss.weld.security.NewInstanceAction;

final class SecurityActions {
    private SecurityActions() {
    }

    static <T> T newInstance(Class<T> javaClass) throws InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (System.getSecurityManager() != null) {
            try {
                Constructor constructor = (Constructor)AccessController.doPrivileged(GetDeclaredConstructorAction.of(javaClass, new Class[0]));
                return AccessController.doPrivileged(NewInstanceAction.of(constructor, new Object[0]));
            }
            catch (PrivilegedActionException e) {
                throw new WeldException(e.getCause());
            }
        }
        return javaClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    static <T> Constructor<T> getDeclaredConstructor(Class<T> javaClass, Class<?> ... parameterTypes) throws NoSuchMethodException, PrivilegedActionException {
        if (System.getSecurityManager() != null) {
            return (Constructor)AccessController.doPrivileged(GetDeclaredConstructorAction.of(javaClass, parameterTypes));
        }
        return javaClass.getDeclaredConstructor(parameterTypes);
    }

    static <T> T newInstance(Constructor<T> constructor, Object ... params) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        if (System.getSecurityManager() != null) {
            try {
                return AccessController.doPrivileged(NewInstanceAction.of(constructor, params));
            }
            catch (PrivilegedActionException e) {
                throw new WeldException(e.getCause());
            }
        }
        return constructor.newInstance(params);
    }

    static void addShutdownHook(final Thread hook) {
        if (System.getSecurityManager() != null) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    Runtime.getRuntime().addShutdownHook(hook);
                    return null;
                }
            });
        } else {
            Runtime.getRuntime().addShutdownHook(hook);
        }
    }
}

