/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.annotated.enhanced.jlr;

import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedParameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedMethod;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedParameter;
import org.jboss.weld.annotated.enhanced.EnhancedAnnotatedType;
import org.jboss.weld.annotated.enhanced.MethodSignature;
import org.jboss.weld.annotated.enhanced.jlr.AbstractEnhancedAnnotatedCallable;
import org.jboss.weld.annotated.enhanced.jlr.EnhancedAnnotatedParameterImpl;
import org.jboss.weld.annotated.enhanced.jlr.MethodSignatureImpl;
import org.jboss.weld.resources.ClassTransformer;
import org.jboss.weld.util.collections.WeldCollections;
import org.jboss.weld.util.reflection.Formats;
import org.jboss.weld.util.reflection.Reflections;

public class EnhancedAnnotatedMethodImpl<T, X>
extends AbstractEnhancedAnnotatedCallable<T, X, Method>
implements EnhancedAnnotatedMethod<T, X> {
    private final List<EnhancedAnnotatedParameter<?, X>> parameters;
    private final String propertyName;
    private final MethodSignature signature;
    private final AnnotatedMethod<X> slim;

    public static <T, X, Y extends X> EnhancedAnnotatedMethodImpl<T, X> of(AnnotatedMethod<X> annotatedMethod, EnhancedAnnotatedType<Y> declaringClass, ClassTransformer classTransformer) {
        EnhancedAnnotatedType downcastDeclaringType = (EnhancedAnnotatedType)Reflections.cast(declaringClass);
        return new EnhancedAnnotatedMethodImpl<T, X>(annotatedMethod, EnhancedAnnotatedMethodImpl.buildAnnotationMap(annotatedMethod.getAnnotations()), EnhancedAnnotatedMethodImpl.buildAnnotationMap(annotatedMethod.getAnnotations()), downcastDeclaringType, classTransformer);
    }

    private EnhancedAnnotatedMethodImpl(AnnotatedMethod<X> annotatedMethod, Map<Class<? extends Annotation>, Annotation> annotationMap, Map<Class<? extends Annotation>, Annotation> declaredAnnotationMap, EnhancedAnnotatedType<X> declaringClass, ClassTransformer classTransformer) {
        super(annotatedMethod, annotationMap, declaredAnnotationMap, classTransformer, declaringClass);
        this.slim = annotatedMethod;
        ArrayList parameters = new ArrayList(annotatedMethod.getParameters().size());
        EnhancedAnnotatedMethodImpl.validateParameterCount(annotatedMethod);
        for (AnnotatedParameter annotatedParameter : annotatedMethod.getParameters()) {
            EnhancedAnnotatedParameter parameter = EnhancedAnnotatedParameterImpl.of(annotatedParameter, this, classTransformer);
            parameters.add(parameter);
        }
        this.parameters = WeldCollections.immutableListView(parameters);
        String propertyName = Reflections.getPropertyName(this.getDelegate());
        this.propertyName = propertyName == null ? this.getName() : propertyName;
        this.signature = new MethodSignatureImpl(this);
    }

    @Override
    public Method getDelegate() {
        return this.slim.getJavaMember();
    }

    @Override
    public List<EnhancedAnnotatedParameter<?, X>> getEnhancedParameters() {
        return this.parameters;
    }

    @Override
    public Class<?>[] getParameterTypesAsArray() {
        return this.slim.getJavaMember().getParameterTypes();
    }

    @Override
    public List<EnhancedAnnotatedParameter<?, X>> getEnhancedParameters(Class<? extends Annotation> annotationType) {
        ArrayList ret = new ArrayList();
        for (EnhancedAnnotatedParameter<?, X> parameter : this.parameters) {
            if (!parameter.isAnnotationPresent(annotationType)) continue;
            ret.add(parameter);
        }
        return ret;
    }

    @Override
    public boolean isEquivalent(Method method) {
        return this.getDeclaringType().isEquivalent(method.getDeclaringClass()) && this.getName().equals(method.getName()) && Arrays.equals(this.getParameterTypesAsArray(), method.getParameterTypes());
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String toString() {
        return Formats.formatAnnotatedMethod(this);
    }

    @Override
    public MethodSignature getSignature() {
        return this.signature;
    }

    @Override
    public List<AnnotatedParameter<X>> getParameters() {
        return (List)Reflections.cast(this.parameters);
    }

    @Override
    public boolean isGeneric() {
        return ((Method)this.getJavaMember()).getTypeParameters().length > 0;
    }

    @Override
    public AnnotatedMethod<X> slim() {
        return this.slim;
    }
}

