/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.epicyro.config.helper;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public final class PriviledgedAccessController {
    private static boolean hasSecurityManager = System.getSecurityManager() != null;

    private PriviledgedAccessController() {
    }

    public static void privilegedWithException(Runnable runnable) throws PrivilegedActionException {
        if (hasSecurityManager) {
            AccessController.doPrivileged(() -> {
                runnable.run();
                return null;
            });
        }
        try {
            runnable.run();
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
    }

    public static Object privilegedNoCheck(Runnable runnable) {
        return AccessController.doPrivileged(() -> {
            runnable.run();
            return null;
        });
    }

    public static <T> T privilegedNoCheck(PrivilegedAction<T> privilegedAction) {
        return AccessController.doPrivileged(privilegedAction);
    }

    public static Object doPrivileged(PrivilegedAction<?> action) {
        if (hasSecurityManager) {
            return AccessController.doPrivileged(action);
        }
        return action.run();
    }

    public static Object doPrivileged(PrivilegedExceptionAction<Object> privilegedExceptionAction) throws PrivilegedActionException {
        if (hasSecurityManager) {
            return AccessController.doPrivileged(privilegedExceptionAction);
        }
        try {
            return privilegedExceptionAction.run();
        }
        catch (Exception e) {
            throw new PrivilegedActionException(e);
        }
    }

    public static <T> T privileged(PrivilegedAction<T> privilegedAction) {
        if (hasSecurityManager) {
            return AccessController.doPrivileged(privilegedAction);
        }
        return privilegedAction.run();
    }

    public static Object privileged(Runnable runnable) {
        if (hasSecurityManager) {
            return AccessController.doPrivileged(() -> {
                runnable.run();
                return null;
            });
        }
        runnable.run();
        return null;
    }
}

