/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.core;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.Monitor;
import com.sun.messaging.jmq.jmsserver.service.MetricManager;
import com.sun.messaging.jmq.util.MetricData;
import java.util.Hashtable;
import java.util.Iterator;

class BrokerMetricsMonitor
extends Monitor {
    BrokerMetricsMonitor(Destination d) {
        super(d);
    }

    @Override
    protected Hashtable getMonitorData() {
        Hashtable<String, Long> mapMessage = new Hashtable<String, Long>();
        MetricManager mm = Globals.getMetricManager();
        MetricData md = mm.getMetrics();
        mapMessage.put("numConnections", Long.valueOf(md.nConnections));
        mapMessage.put("numMsgsIn", md.totals.messagesIn);
        mapMessage.put("numMsgsOut", md.totals.messagesOut);
        Globals.getDestinationList();
        mapMessage.put("numMsgs", Long.valueOf(DestinationList.totalCount()));
        mapMessage.put("msgBytesIn", md.totals.messageBytesIn);
        mapMessage.put("msgBytesOut", md.totals.messageBytesOut);
        mapMessage.put("numPktsIn", md.totals.packetsIn);
        mapMessage.put("numPktsOut", md.totals.packetsOut);
        mapMessage.put("pktBytesIn", md.totals.packetBytesIn);
        mapMessage.put("pktBytesOut", md.totals.packetBytesOut);
        Globals.getDestinationList();
        mapMessage.put("totalMsgBytes", DestinationList.totalBytes());
        Globals.getDestinationList();
        Iterator[] itrs = DestinationList.getAllDestinations(null);
        Iterator itr = itrs[0];
        long numDests = 0L;
        while (itr.hasNext()) {
            Destination oneDest = (Destination)itr.next();
            if (oneDest.isInternal() || oneDest.isAdmin() || oneDest.getDestinationName().equals("__JMQBridgeAdmin") || oneDest.getDestinationName().equals("__JMQAdmin")) continue;
            ++numDests;
        }
        mapMessage.put("numDestinations", numDests);
        return mapMessage;
    }
}

