/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.security;

import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedExceptionAction;
import org.jboss.weld.security.AbstractGenericReflectionAction;

public class ConstructorNewInstanceAction<T>
extends AbstractGenericReflectionAction<T>
implements PrivilegedExceptionAction<T> {
    private final Class<?>[] constructorParamTypes;
    private final Object[] constructorParamInstances;

    public static <T> ConstructorNewInstanceAction<T> of(Class<T> javaClass, Class<?>[] constructorParamTypes, Object ... constructorParamInstances) {
        return new ConstructorNewInstanceAction<T>(javaClass, constructorParamTypes, constructorParamInstances);
    }

    public ConstructorNewInstanceAction(Class<T> javaClass, Class<?>[] constructorParamTypes, Object ... constructorParamInstances) {
        super(javaClass);
        this.constructorParamTypes = (Class[])constructorParamTypes.clone();
        this.constructorParamInstances = constructorParamInstances;
    }

    @Override
    public T run() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return this.javaClass.getConstructor(this.constructorParamTypes).newInstance(this.constructorParamInstances);
    }
}

