/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.appclient;

import com.sun.enterprise.iiop.security.AlternateSecurityInterceptorFactory;
import com.sun.enterprise.iiop.security.SecClientRequestInterceptor;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.enterprise.iiop.api.IIOPInterceptorFactory;
import org.jvnet.hk2.annotations.Service;
import org.omg.IOP.Codec;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

@Service(name="ClientSecurityInterceptorFactory")
@Singleton
public class AppclientIIOPInterceptorFactory
implements IIOPInterceptorFactory {
    private static final System.Logger LOG = System.getLogger(AppclientIIOPInterceptorFactory.class.getName());
    private static final String FACTORY = System.getProperty("com.sun.enterprise.iiop.security.interceptorFactory");
    private ClientRequestInterceptor clientRequestInterceptor;
    @Inject
    private ProcessEnvironment processEnvironment;
    private AlternateSecurityInterceptorFactory altSecFactory;

    public ClientRequestInterceptor createClientRequestInterceptor(ORBInitInfo info, Codec codec) {
        if (this.processEnvironment.getProcessType().isServer()) {
            return null;
        }
        if (this.altSecFactory != null || FACTORY != null && this.createAlternateSecurityInterceptorFactory()) {
            return this.altSecFactory.getClientRequestInterceptor(codec);
        }
        return this.getClientInterceptorInstance(codec);
    }

    public ServerRequestInterceptor createServerRequestInterceptor(ORBInitInfo info, Codec codec) {
        return null;
    }

    private synchronized boolean createAlternateSecurityInterceptorFactory() {
        try {
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(FACTORY);
            if (AlternateSecurityInterceptorFactory.class.isAssignableFrom(clazz) && !clazz.isInterface()) {
                this.altSecFactory = (AlternateSecurityInterceptorFactory)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return true;
            }
            LOG.log(System.Logger.Level.ERROR, "Not a valid factory class: {0}. Must implement {1}", FACTORY, AlternateSecurityInterceptorFactory.class);
        }
        catch (ReflectiveOperationException ex) {
            LOG.log(System.Logger.Level.ERROR, "Interceptor Factory class " + FACTORY + " not loaded: ", (Throwable)ex);
        }
        return false;
    }

    private synchronized ClientRequestInterceptor getClientInterceptorInstance(Codec codec) {
        if (this.clientRequestInterceptor == null) {
            this.clientRequestInterceptor = new SecClientRequestInterceptor("SecClientRequestInterceptor", codec);
        }
        return this.clientRequestInterceptor;
    }
}

