/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.util.ArrayUtil;

public class PasswordHasher {
    private static final String ENCODING = "UTF-8";
    public static final String ID_PATTERN_SHA1_SCHEME = "3b60";
    public static final String ID_PATTERN_CONFIGURABLE_HASH_SCHEME = "3b61";
    public static final String ID_PATTERN_CONFIGURABLE_STRETCHED_SCHEME = "3b62";
    private static final char SEPARATOR_CHAR = ':';
    private String _messageDigestAlgorithm;
    private byte[] _salt;
    private int _iterations;

    public PasswordHasher(String string, byte[] byArray, int n) {
        this._messageDigestAlgorithm = string;
        this._salt = ArrayUtil.copy(byArray);
        this._iterations = n;
    }

    public PasswordHasher(String string) {
        if (string.startsWith(ID_PATTERN_CONFIGURABLE_HASH_SCHEME)) {
            this._messageDigestAlgorithm = string.substring(string.indexOf(58) + 1);
            this._salt = null;
            this._iterations = 1;
        } else if (string.startsWith(ID_PATTERN_CONFIGURABLE_STRETCHED_SCHEME)) {
            int n = string.indexOf(58) + 1;
            int n2 = string.indexOf(58, n) + 1;
            int n3 = string.indexOf(58, n2) + 1;
            this._salt = StringUtil.fromHexString(string, n, n2 - n - 1);
            this._iterations = Integer.parseInt(string.substring(n2, n3 - 1));
            this._messageDigestAlgorithm = string.substring(n3);
        }
    }

    public String hashPasswordIntoString(String string, String string2) throws StandardException {
        byte[] byArray;
        byte[] byArray2;
        if (string2 == null) {
            return null;
        }
        try {
            byArray2 = string.getBytes(ENCODING);
            byArray = string2.getBytes(ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw StandardException.plainWrapException(unsupportedEncodingException);
        }
        MessageDigest messageDigest = this.getEmptyMessageDigest();
        byte[] byArray3 = null;
        for (int i = 0; i < this._iterations; ++i) {
            messageDigest.reset();
            if (byArray3 != null) {
                messageDigest.update(byArray3);
            }
            messageDigest.update(byArray2);
            messageDigest.update(byArray);
            if (this._salt != null) {
                messageDigest.update(this._salt);
            }
            byArray3 = messageDigest.digest();
        }
        return StringUtil.toHexString(byArray3, 0, byArray3.length);
    }

    private MessageDigest getEmptyMessageDigest() throws StandardException {
        if (this._messageDigestAlgorithm == null) {
            throw this.badMessageDigest(null);
        }
        try {
            return MessageDigest.getInstance(this._messageDigestAlgorithm);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw this.badMessageDigest(noSuchAlgorithmException);
        }
    }

    private StandardException badMessageDigest(Throwable throwable) {
        String string = this._messageDigestAlgorithm == null ? "NULL" : this._messageDigestAlgorithm;
        return StandardException.newException("XBCXW.S", throwable, string);
    }

    public String encodeHashingScheme() {
        return this.hashAndEncode("");
    }

    public String hashAndEncode(String string, String string2) throws StandardException {
        String string3 = this.hashPasswordIntoString(string, string2);
        return this.hashAndEncode(string3);
    }

    private String hashAndEncode(String string) {
        if ((this._salt == null || this._salt.length == 0) && this._iterations == 1) {
            return ID_PATTERN_CONFIGURABLE_HASH_SCHEME + string + ":" + this._messageDigestAlgorithm;
        }
        return ID_PATTERN_CONFIGURABLE_STRETCHED_SCHEME + string + ":" + StringUtil.toHexString(this._salt, 0, this._salt.length) + ":" + this._iterations + ":" + this._messageDigestAlgorithm;
    }
}

