/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.io.Serializable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.AbstractImmutableSet;
import org.jboss.weld.util.collections.ImmutableSet;

public final class ImmutableHashSet<T>
extends ImmutableSet<T>
implements Serializable {
    private static final int MAX_CAPACITY = 30;
    private static final float LOAD_FACTOR = 0.75f;
    private static final int MAX_SIZE = (int)Math.floor(8.05306368E8);
    private static final long serialVersionUID = 1L;
    private final Object[] table;
    private final int size;
    private final int hashCode;

    public ImmutableHashSet(Set<T> data) {
        Preconditions.checkNotNull(data);
        Preconditions.checkArgument(!data.isEmpty(), data);
        Preconditions.checkArgument(data.size() < MAX_SIZE, "Collection too large: " + data.size());
        this.size = data.size();
        this.table = new Object[ImmutableHashSet.tableSize(this.size)];
        for (T element : data) {
            this.storeElement(element);
        }
        this.hashCode = data.hashCode();
    }

    private static int tableSize(int dataSize) {
        int candidate = Integer.highestOneBit(dataSize) << 1;
        if ((float)candidate * 0.75f < (float)dataSize) {
            return Integer.highestOneBit(dataSize) << 2;
        }
        return candidate;
    }

    private int getTableIndex(int hashCode) {
        return hashCode & this.table.length - 1;
    }

    private void storeElement(T element) {
        int i = element.hashCode();
        while (true) {
            int index;
            if (this.table[index = this.getTableIndex(i)] == null) {
                this.table[index] = element;
                return;
            }
            ++i;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        int i = o.hashCode();
        Object item;
        while ((item = this.table[this.getTableIndex(i)]) != null) {
            if (o.equals(item)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractImmutableSet) {
            AbstractImmutableSet that = (AbstractImmutableSet)obj;
            if (this.hashCode() != that.hashCode()) {
                return false;
            }
            return this.equalsSet(that);
        }
        if (obj instanceof Set) {
            return this.equalsSet((Set)obj);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public Iterator<T> iterator() {
        return new IteratorImpl();
    }

    private class IteratorImpl
    implements Iterator<T> {
        private int position = -1;
        private int processedElements = 0;

        private IteratorImpl() {
        }

        @Override
        public boolean hasNext() {
            return this.processedElements < ImmutableHashSet.this.size;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.position;
            while (ImmutableHashSet.this.table[this.position] == null) {
                ++this.position;
            }
            ++this.processedElements;
            return ImmutableHashSet.this.table[this.position];
        }
    }
}

