/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.management.agent.Agent;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.ConsumerInfoNotifyManager;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.lists.WeakValueHashMap;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.timer.MQTimer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimerTask;
import java.util.Vector;

public class ConnectionManager
extends WeakValueHashMap<ConnectionUID, Connection> {
    private static boolean DEBUG = false;
    private Logger logger = Globals.getLogger();
    long lastConCheck = 0L;
    public static final int pingTimeout = Globals.getConfig().getIntProperty("imq.ping.interval", 120) * 1000;
    public boolean PING_ENABLED = Globals.getConfig().getBooleanProperty("imq.ping.enabled", true);
    public static final long DEFAULT_RECONNECT_INTERVAL = 10000L;
    private ConnectionWatcher connectionWatcher = null;
    private int destroyCount = 0;
    private int addCount = 0;
    public Object addLock = new Object();
    private ConsumerInfoNotifyManager cinmgr = new ConsumerInfoNotifyManager(this);

    public ConnectionManager() {
        super("ConnectionManager");
    }

    public Connection matchProperty(String name, Object value) {
        List<Connection> al = this.getConnectionList(null);
        for (Connection c : al) {
            Object v = c.getClientData(name);
            if (value != v && (value == null || !value.equals(v))) continue;
            return c;
        }
        return null;
    }

    public void removeFromClientDataList(String name, Object value) {
        List<Connection> al = this.getConnectionList(null);
        for (Connection c : al) {
            Object v = c.getClientData(name);
            if (v == null || value == null || !(v instanceof List)) continue;
            ((List)v).remove(value);
        }
    }

    private void startTimer() {
        if (this.PING_ENABLED && this.connectionWatcher == null) {
            this.lastConCheck = System.currentTimeMillis();
            MQTimer timer = Globals.getTimer(true);
            this.connectionWatcher = new ConnectionWatcher();
            try {
                timer.schedule((TimerTask)this.connectionWatcher, pingTimeout, (long)pingTimeout);
            }
            catch (IllegalStateException ex) {
                this.logger.log(4, "Timer shutting down", ex);
            }
        }
    }

    private void stopTimer() {
        if (this.connectionWatcher != null) {
            this.connectionWatcher.cancel();
            this.connectionWatcher = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnectionUID(ConnectionUID currentID, ConnectionUID oldid) {
        Object object = this.addLock;
        synchronized (object) {
            if (this.destroyCount > 0) {
                try {
                    this.addLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++this.addCount;
        }
        try {
            object = this;
            synchronized (object) {
                Connection o = (Connection)this.remove(oldid);
                if (o != null) {
                    this.put(currentID, o);
                }
            }
        }
        finally {
            object = this.addLock;
            synchronized (object) {
                --this.addCount;
                this.addLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(Connection con) throws BrokerException {
        Object object = this.addLock;
        synchronized (object) {
            if (this.destroyCount > 0) {
                try {
                    this.addLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++this.addCount;
        }
        try {
            object = this;
            synchronized (object) {
                this.put(con.getConnectionUID(), con);
                if (this.size() == 1 && this.PING_ENABLED) {
                    this.startTimer();
                }
            }
        }
        finally {
            object = this.addLock;
            synchronized (object) {
                --this.addCount;
                this.addLock.notifyAll();
            }
        }
        if (DEBUG) {
            this.logger.log(4, "B1000", (Object)con.toString(), String.valueOf(this.size()));
            this.logCM(1);
        }
    }

    public synchronized Connection getConnection(ConnectionUID id) {
        return (Connection)this.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(ConnectionUID id, boolean say_goodbye, int reason, String reasonStr) {
        if (!this.containsKey(id)) {
            return;
        }
        Agent agent = Globals.getAgent();
        if (agent != null) {
            agent.notifyConnectionClose(id.longValue());
            agent.unregisterConnection(id.longValue());
        }
        Object object = this.addLock;
        synchronized (object) {
            if (this.addCount > 0) {
                try {
                    this.addLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ++this.destroyCount;
        }
        try {
            Connection con = null;
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                con = (Connection)this.remove(id);
                if (this.isEmpty() && this.PING_ENABLED) {
                    this.stopTimer();
                }
            }
            if (con != null) {
                this.destroyConnectionData(con, say_goodbye, reason, reasonStr);
            }
        }
        finally {
            object = this.addLock;
            synchronized (object) {
                --this.destroyCount;
                this.addLock.notifyAll();
            }
        }
    }

    private void destroyConnectionData(Connection con, boolean say_goodbye, int reason, String reasonStr) {
        if (con == null) {
            return;
        }
        if (DEBUG) {
            this.logger.log(4, "B1008", (Object)con.toString(), String.valueOf(this.size()));
        }
        if (reason == 1) {
            con.shutdownConnection(reasonStr);
        } else {
            con.destroyConnection(say_goodbye, reason, reasonStr);
        }
        if (DEBUG) {
            this.logCM(1);
        }
    }

    private void logCM(int loglevel) {
        this.logger.log(loglevel, "ConnectionManager: " + this.size());
        Set keys = this.entrySet();
        Iterator itr = keys.iterator();
        int i = 0;
        while (itr.hasNext()) {
            this.logger.log(loglevel, "{0}:{1}", (Object)String.valueOf(i), itr.next().toString());
            ++i;
        }
    }

    public Vector<String> getDebugState(Service svc) {
        List<Connection> cons = this.getConnectionList(svc);
        Vector<String> v = new Vector<String>();
        for (int i = cons.size() - 1; i >= 0; --i) {
            Connection con = cons.get(i);
            v.add(String.valueOf(con.getConnectionUID().longValue()));
        }
        return v;
    }

    public synchronized int getNumConnections(Service svc) {
        int total = 0;
        for (Connection con : this.values()) {
            if (svc != null && con.getService() != svc) continue;
            ++total;
        }
        return total;
    }

    public synchronized List<Connection> getConnectionList(Service svc) {
        ArrayList<Connection> list = new ArrayList<Connection>();
        for (Connection con : this.values()) {
            if (svc != null && con.getService() != svc) continue;
            list.add(con);
        }
        return list;
    }

    public void debug() {
        List<Connection> l = this.getConnectionList(null);
        this.logger.log(8, "Connection count " + l.size());
        for (Connection c : l) {
            this.logger.log(8, "Connection " + String.valueOf(c));
            c.debug("\t");
        }
    }

    public void broadcastGoodbye(int reason, String msg) {
        this.broadcastGoodbye(reason, msg, null);
    }

    public void broadcastGoodbye(int reason, String msg, Connection excludedConn) {
        List<Connection> cons = this.getConnectionList(null);
        for (int i = cons.size() - 1; i >= 0; --i) {
            Connection con = cons.get(i);
            if (excludedConn != null && con == excludedConn) continue;
            con.sayGoodbye(reason, msg);
        }
    }

    public void flushControlMessages(long time) {
        List<Connection> cons = this.getConnectionList(null);
        for (int i = cons.size() - 1; i >= 0; --i) {
            Connection con = cons.get(i);
            con.flushConnection(time);
        }
    }

    public void checkAllConnections() {
        List<Connection> cons = this.getConnectionList(null);
        for (int i = cons.size() - 1; i >= 0; --i) {
            Connection con = cons.get(i);
            long access = con.getAccessTime();
            if (this.lastConCheck == 0L || access == 0L || access >= this.lastConCheck) continue;
            con.checkConnection();
        }
        this.lastConCheck = System.currentTimeMillis();
    }

    public long getMaxReconnectInterval() {
        List<Connection> cons = this.getConnectionList(null);
        Connection con = null;
        long max = 10000L;
        long interval = 0L;
        for (int i = cons.size() - 1; i >= 0; --i) {
            con = cons.get(i);
            interval = con.getReconnectInterval();
            if (interval <= max) continue;
            max = interval;
        }
        return max;
    }

    public ConsumerInfoNotifyManager getConsumerInfoNotifyManager() {
        return this.cinmgr;
    }

    protected void sendConsumerInfo(int requestType, DestinationUID duid, int destType, int infoType, boolean sendToWildcard) {
        List<Connection> cons = this.getConnectionList(null);
        for (int i = cons.size() - 1; i >= 0; --i) {
            Connection con = cons.get(i);
            con.sendConsumerInfo(requestType, duid, destType, infoType, sendToWildcard);
        }
    }

    public void cleanupMemory(boolean persistent) {
        if (persistent) {
            this.logger.log(4, "Swapping all unacknowldged messages from memory (messages will remain persisted )");
        } else {
            this.logger.log(4, "Swapping all unacknowldged messages from memory (messages will be swapped to disk)");
        }
    }

    class ConnectionWatcher
    extends TimerTask {
        ConnectionWatcher() {
        }

        @Override
        public void run() {
            ConnectionManager.this.checkAllConnections();
        }
    }
}

