/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterNotifyPartitionArrivalInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ProtocolGlobals;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import java.io.IOException;

public class NotifyPartitionArrivalHandler
extends GPacketHandler {
    private static boolean DEBUG = false;

    public NotifyPartitionArrivalHandler(RaptorProtocol p) {
        super(p);
    }

    @Override
    public void handle(BrokerAddress sender, GPacket pkt) {
        if (DEBUG) {
            this.logger.log(4, "NotifyPartitionArrivalHandler");
        }
        if (pkt.getType() == 75) {
            this.handleNotifyPartitionArrival(sender, pkt);
        } else if (pkt.getType() == 76) {
            this.handleNotifyPartitionArrivalReply(sender, pkt);
        } else {
            this.logger.log(16, "NotifyPartitionArrivalHandler: unexpected packet type " + pkt.toLongString());
        }
    }

    private void handleNotifyPartitionArrival(BrokerAddress sender, GPacket pkt) {
        ClusterNotifyPartitionArrivalInfo npa = ClusterNotifyPartitionArrivalInfo.newInstance(pkt, this.c);
        int status = 200;
        String reason = null;
        try {
            this.p.receivedNotifyPartitionArrival(sender, pkt, npa);
        }
        catch (Exception e) {
            status = 500;
            Object[] args = new String[]{ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()), sender.toString(), e.toString()};
            reason = this.br.getKString("B3269", args);
            this.logger.logStack(32, reason, e);
        }
        this.sendReply(sender, npa, status, reason);
    }

    private void handleNotifyPartitionArrivalReply(BrokerAddress sender, GPacket pkt) {
        ClusterNotifyPartitionArrivalInfo npa = ClusterNotifyPartitionArrivalInfo.newInstance(pkt, this.c);
        try {
            this.p.receivedNotifyPartitionArrivalReply(sender, pkt, npa);
        }
        catch (Exception e) {
            Object[] args = new String[]{ProtocolGlobals.getPacketTypeDisplayString(pkt.getType()), sender.toString(), e.toString()};
            String reason = this.br.getKString("B3269", args);
            this.logger.logStack(16, reason, e);
        }
    }

    private void sendReply(BrokerAddress sender, ClusterNotifyPartitionArrivalInfo npa, int status, String reason) {
        if (npa.needReply()) {
            try {
                this.c.unicast(sender, npa.getReplyGPacket(status, reason));
            }
            catch (IOException e) {
                Object[] args = new Object[]{ProtocolGlobals.getPacketTypeDisplayString(76), sender, npa.toString()};
                this.logger.logStack(32, this.br.getKString("B3192", (Object)args), e);
            }
        }
    }
}

