/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data.handlers.admin;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.api.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.api.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.core.BrokerMQAddress;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminCmdHandler;
import com.sun.messaging.jmq.jmsserver.data.handlers.admin.AdminDataHandler;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class GetClusterHandler
extends AdminCmdHandler {
    private static boolean DEBUG = GetClusterHandler.getDEBUG();

    public GetClusterHandler(AdminDataHandler parent) {
        super(parent);
    }

    public static int convertState(BrokerState state) {
        if (state == BrokerState.INITIALIZING) {
            return 8;
        }
        if (state == BrokerState.OPERATING) {
            return 0;
        }
        if (state == BrokerState.QUIESCE_STARTED) {
            return 4;
        }
        if (state == BrokerState.QUIESCE_COMPLETED) {
            return 5;
        }
        if (state == BrokerState.SHUTDOWN_STARTED) {
            return 6;
        }
        if (state == BrokerState.SHUTDOWN_COMPLETE) {
            return 7;
        }
        if (state == BrokerState.SHUTDOWN_FAILOVER) {
            return 7;
        }
        if (state == BrokerState.FAILOVER_PENDING) {
            return 7;
        }
        if (state == BrokerState.FAILOVER_STARTED) {
            return 1;
        }
        if (state == BrokerState.FAILOVER_COMPLETE) {
            return 2;
        }
        if (state == BrokerState.FAILOVER_FAILED) {
            return 3;
        }
        if (state == BrokerState.FAILOVER_PROCESSED) {
            return 2;
        }
        return 7;
    }

    public static Hashtable getBrokerClusterInfo(ClusteredBroker cb, Logger logger) {
        Hashtable<String, Object> h = new Hashtable<String, Object>();
        String brkid = cb.isBrokerIDGenerated() ? "" : cb.getBrokerName();
        h.put("ID", brkid);
        BrokerMQAddress bm = (BrokerMQAddress)cb.getBrokerURL();
        String address = bm.getHostAddressNPort();
        h.put("Address", address);
        h.put("Version", String.valueOf(cb.getVersion()));
        if (cb instanceof HAClusteredBroker) {
            try {
                HAClusteredBroker hcb = (HAClusteredBroker)cb;
                h.put("StatusTimestamp", hcb.getHeartbeat());
                String tk = hcb.getTakeoverBroker();
                if (tk != null) {
                    h.put("TakeoverBrokerID", tk);
                }
                int cnt = Globals.getStore().getMessageCount(brkid);
                h.put("NumMsgs", Long.valueOf(cnt));
            }
            catch (Exception hcb) {
                // empty catch block
            }
        }
        Globals.getDestinationList();
        if (DestinationList.isPartitionMode()) {
            Globals.getDestinationList();
            if (DestinationList.isPartitionMigratable()) {
                h.put("imq.partitionmigratable", "true");
                if (cb.isLocalBroker()) {
                    Globals.getDestinationList();
                    h.put("JMQNumPartitions", DestinationList.getNumPartitions());
                }
            }
        }
        try {
            h.put("State", GetClusterHandler.convertState(cb.getState()));
        }
        catch (Exception ex) {
            if (logger != null) {
                logger.logStack(16, ex.getMessage(), ex);
            }
            h.put("State", 7);
        }
        return h;
    }

    @Override
    public boolean handle(IMQConnection con, Packet cmd_msg, Hashtable cmd_props) {
        if (DEBUG) {
            this.logger.log(4, this.getClass().getName() + ": Getting cluster info/state: " + String.valueOf(cmd_props));
        }
        Vector<Hashtable> v = new Vector<Hashtable>();
        int status = 200;
        String errMsg = null;
        ClusterManager cm = Globals.getClusterManager();
        Iterator itr = cm.getKnownBrokers(true);
        while (itr.hasNext()) {
            ClusteredBroker cb = (ClusteredBroker)itr.next();
            Hashtable h = GetClusterHandler.getBrokerClusterInfo(cb, this.logger);
            v.add(h);
        }
        Packet reply = new Packet(con.useDirectBuffers());
        reply.setPacketType(5);
        GetClusterHandler.setProperties(reply, 79, status, errMsg);
        this.setBodyObject(reply, v);
        this.parent.sendReply(con, cmd_msg, reply);
        return true;
    }
}

