/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.List;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.shared.common.error.StandardException;

class ValueNodeList
extends QueryTreeNodeVector<ValueNode> {
    ValueNodeList(ContextManager contextManager) {
        super(ValueNode.class, contextManager);
    }

    void addValueNode(ValueNode valueNode) throws StandardException {
        this.addElement(valueNode);
    }

    void bindExpression(FromList fromList, SubqueryList subqueryList, List<AggregateNode> list) throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ValueNode valueNode = (ValueNode)this.elementAt(i);
            valueNode = valueNode.bindExpression(fromList, subqueryList, list);
            this.setElementAt(valueNode, i);
        }
    }

    void genSQLJavaSQLTrees() throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ValueNode valueNode = (ValueNode)this.elementAt(i);
            if (!valueNode.getTypeId().userType()) continue;
            this.setElementAt(valueNode.genSQLJavaSQLTree(), i);
        }
    }

    DataTypeDescriptor getDominantTypeServices() throws StandardException {
        DataTypeDescriptor dataTypeDescriptor = null;
        int n = -1;
        int n2 = -1;
        boolean bl = false;
        for (int i = 0; i < this.size(); ++i) {
            ValueNode valueNode = (ValueNode)this.elementAt(i);
            if (valueNode.requiresTypeFromContext() && valueNode.getTypeServices() == null) continue;
            DataTypeDescriptor dataTypeDescriptor2 = valueNode.getTypeServices();
            if (dataTypeDescriptor2.getTypeId().isStringTypeId()) {
                if (n == -1) {
                    n = dataTypeDescriptor2.getCollationDerivation();
                    n2 = dataTypeDescriptor2.getCollationType();
                } else if (!bl) {
                    if (n != dataTypeDescriptor2.getCollationDerivation()) {
                        bl = true;
                    } else if (n2 != dataTypeDescriptor2.getCollationType()) {
                        bl = true;
                    }
                }
            }
            dataTypeDescriptor = dataTypeDescriptor == null ? dataTypeDescriptor2 : dataTypeDescriptor.getDominantType(dataTypeDescriptor2, this.getClassFactory());
        }
        if (n != -1 && bl) {
            dataTypeDescriptor = dataTypeDescriptor.getCollatedType(dataTypeDescriptor.getCollationType(), 0);
        }
        return dataTypeDescriptor;
    }

    DataTypeDescriptor getTypeServices() throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ValueNode valueNode = (ValueNode)this.elementAt(i);
            DataTypeDescriptor dataTypeDescriptor = valueNode.getTypeServices();
            if (dataTypeDescriptor == null) continue;
            return dataTypeDescriptor;
        }
        return null;
    }

    boolean allSamePrecendence(int n) {
        boolean bl = true;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            ValueNode valueNode = (ValueNode)this.elementAt(i);
            DataTypeDescriptor dataTypeDescriptor = valueNode.getTypeServices();
            if (dataTypeDescriptor == null) {
                return false;
            }
            if (n == dataTypeDescriptor.getTypeId().typePrecedence()) continue;
            return false;
        }
        return bl;
    }

    void compatible(ValueNode valueNode) throws StandardException {
        TypeId typeId = valueNode.getTypeId();
        TypeCompiler typeCompiler = valueNode.getTypeCompiler();
        for (ValueNode valueNode2 : this) {
            if (valueNode2.requiresTypeFromContext() || typeCompiler.compatible(valueNode2.getTypeId())) continue;
            throw StandardException.newException("42815.S.171", typeId.getSQLTypeName(), valueNode2.getTypeId().getSQLTypeName());
        }
    }

    void comparable(ValueNode valueNode) throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ValueNode valueNode2 = (ValueNode)this.elementAt(i);
            if (valueNode.getTypeServices().comparable(valueNode2.getTypeServices(), false, this.getClassFactory())) continue;
            throw StandardException.newException("42818", valueNode.getTypeServices().getSQLTypeNameWithCollation(), valueNode2.getTypeServices().getSQLTypeNameWithCollation());
        }
    }

    boolean isNullable() throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!((ValueNode)this.elementAt(i)).getTypeServices().isNullable()) continue;
            return true;
        }
        return false;
    }

    boolean containsParameterNode() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (!((ValueNode)this.elementAt(i)).requiresTypeFromContext()) continue;
            return true;
        }
        return false;
    }

    boolean containsAllParameterNodes() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (((ValueNode)this.elementAt(i)).requiresTypeFromContext()) continue;
            return false;
        }
        return true;
    }

    boolean containsAllConstantNodes() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.elementAt(i) instanceof ConstantNode) continue;
            return false;
        }
        return true;
    }

    boolean containsOnlyConstantAndParamNodes() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ValueNode valueNode = (ValueNode)this.elementAt(i);
            if (valueNode.requiresTypeFromContext() || valueNode instanceof ConstantNode) continue;
            return false;
        }
        return true;
    }

    void sortInAscendingOrder(DataValueDescriptor dataValueDescriptor) throws StandardException {
        int n = this.size();
        boolean bl = true;
        while (bl) {
            bl = false;
            for (int i = 1; i < n; ++i) {
                ConstantNode constantNode = (ConstantNode)this.elementAt(i);
                DataValueDescriptor dataValueDescriptor2 = constantNode.getValue();
                ConstantNode constantNode2 = (ConstantNode)this.elementAt(i - 1);
                DataValueDescriptor dataValueDescriptor3 = constantNode2.getValue();
                if ((dataValueDescriptor != null || dataValueDescriptor3.compare(dataValueDescriptor2) <= 0) && (dataValueDescriptor == null || !dataValueDescriptor.greaterThan(dataValueDescriptor3, dataValueDescriptor2).equals(true))) continue;
                this.setElementAt(constantNode, i - 1);
                this.setElementAt(constantNode2, i);
                bl = true;
            }
        }
    }

    void eliminateNots(boolean bl) throws StandardException {
        for (int i = 0; i < this.size(); ++i) {
            this.setElementAt(((ValueNode)this.elementAt(i)).eliminateNots(bl), i);
        }
    }

    void setParameterDescriptor(DataTypeDescriptor dataTypeDescriptor) throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            ValueNode valueNode = (ValueNode)this.elementAt(i);
            if (!valueNode.requiresTypeFromContext()) continue;
            valueNode.setType(dataTypeDescriptor);
        }
    }

    void preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            ValueNode valueNode = ((ValueNode)this.elementAt(i)).preprocess(n, fromList, subqueryList, predicateList);
            this.setElementAt(valueNode, i);
        }
    }

    ValueNodeList remapColumnReferencesToExpressions() throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            this.setElementAt(((ValueNode)this.elementAt(i)).remapColumnReferencesToExpressions(), i);
        }
        return this;
    }

    boolean isEquivalent(ValueNodeList valueNodeList) throws StandardException {
        if (this.size() != valueNodeList.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            ValueNode valueNode;
            ValueNode valueNode2 = (ValueNode)this.elementAt(i);
            if (valueNode2.isEquivalent(valueNode = (ValueNode)valueNodeList.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    boolean isConstantExpression() {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            boolean bl = ((ValueNode)this.elementAt(i)).isConstantExpression();
            if (bl) continue;
            return bl;
        }
        return true;
    }

    boolean constantExpression(PredicateList predicateList) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            boolean bl = ((ValueNode)this.elementAt(i)).constantExpression(predicateList);
            if (bl) continue;
            return bl;
        }
        return true;
    }

    boolean categorize(JBitSet jBitSet, boolean bl) throws StandardException {
        boolean bl2 = true;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            bl2 = ((ValueNode)this.elementAt(i)).categorize(jBitSet, bl) && bl2;
        }
        return bl2;
    }

    protected int getOrderableVariantType() throws StandardException {
        int n = 3;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            int n3 = ((ValueNode)this.elementAt(i)).getOrderableVariantType();
            n = Math.min(n, n3);
        }
        return n;
    }
}

