/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.util;

import com.sun.gjc.monitoring.JdbcRAConstants;
import com.sun.gjc.monitoring.SQLTraceProbeProvider;
import com.sun.gjc.util.MethodExecutor;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.jdbc.SQLTraceListener;
import org.glassfish.api.jdbc.SQLTraceRecord;
import org.glassfish.api.naming.SimpleJndiName;

public class SQLTraceDelegator
implements SQLTraceListener {
    private static Logger _logger = LogDomains.getLogger(MethodExecutor.class, (String)"jakarta.enterprise.resource.resourceadapter");
    protected List<SQLTraceListener> sqlTraceListenersList;
    private final SimpleJndiName poolName;
    private InvocationManager invocationManager;
    private SQLTraceProbeProvider probeProvider = null;

    public SQLTraceProbeProvider getProbeProvider() {
        return this.probeProvider;
    }

    public SQLTraceDelegator(SimpleJndiName poolName, InvocationManager invocationManager) {
        this.poolName = poolName;
        this.invocationManager = invocationManager;
        this.probeProvider = new SQLTraceProbeProvider();
    }

    public void registerSQLTraceListener(SQLTraceListener listener) {
        if (this.sqlTraceListenersList == null) {
            this.sqlTraceListenersList = new ArrayList<SQLTraceListener>();
        }
        this.sqlTraceListenersList.add(listener);
    }

    public void sqlTrace(SQLTraceRecord record) {
        if (record != null) {
            record.setPoolName(this.poolName.toString());
            String sqlQuery = this.findSqlQuery(record);
            record.setSqlQuery(sqlQuery);
            record.setApplicationName(this.getAppName());
            record.setModuleName(this.getModuleName());
            if (sqlQuery != null) {
                this.probeProvider.traceSQLEvent(this.poolName.toString(), record.getApplicationName(), record.getModuleName(), sqlQuery);
            }
            if (this.sqlTraceListenersList != null && !this.sqlTraceListenersList.isEmpty()) {
                this.getCallingApplicationStackFrame().ifPresent(arg_0 -> ((SQLTraceRecord)record).setCallingApplicationMethod(arg_0));
                for (SQLTraceListener listener : this.sqlTraceListenersList) {
                    try {
                        listener.sqlTrace(record);
                    }
                    catch (Exception e) {
                        if (!_logger.isLoggable(Level.FINEST)) continue;
                        _logger.log(Level.FINEST, "exception from one of the SQL trace listeners [" + listener.getClass().getName() + "]", e);
                    }
                }
            }
        }
    }

    private Optional<StackWalker.StackFrame> getCallingApplicationStackFrame() {
        HashSet checkedClasses = new HashSet();
        checkedClasses.add(this.getClass());
        return StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(traces -> traces.filter(trace -> {
            boolean result;
            Class<?> declaringClass = trace.getDeclaringClass();
            ClassLoader appClassLoader = Thread.currentThread().getContextClassLoader();
            boolean bl = result = !checkedClasses.contains(declaringClass) && this.isClassFromApplication(declaringClass, appClassLoader);
            if (!result) {
                checkedClasses.add(declaringClass);
            }
            return result;
        }).findFirst());
    }

    private boolean isClassFromApplication(Class<?> cls, ClassLoader appClassLoader) {
        for (ClassLoader clsClassLoader = cls.getClassLoader(); clsClassLoader != null; clsClassLoader = clsClassLoader.getParent()) {
            if (!clsClassLoader.equals(appClassLoader)) continue;
            return true;
        }
        return false;
    }

    private String findSqlQuery(SQLTraceRecord record) {
        String sqlQuery;
        block0: {
            Object param;
            Object[] objectArray;
            int n;
            int n2;
            Object[] params;
            String methodName = record.getMethodName();
            sqlQuery = null;
            if (!this.isMethodValidForCaching(methodName) || (params = record.getParams()) == null || params.length <= 0 || (n2 = 0) >= (n = (objectArray = params).length) || !((param = objectArray[n2]) instanceof String)) break block0;
            sqlQuery = param.toString();
        }
        return sqlQuery;
    }

    private String getAppName() {
        ComponentInvocation currentInvocation = this.invocationManager.getCurrentInvocation();
        return currentInvocation != null ? currentInvocation.getAppName() : null;
    }

    private String getModuleName() {
        ComponentInvocation currentInvocation = this.invocationManager.getCurrentInvocation();
        return currentInvocation != null ? currentInvocation.getModuleName() : null;
    }

    private boolean isMethodValidForCaching(String methodName) {
        return JdbcRAConstants.validSqlTracingMethodNames.contains(methodName);
    }
}

