/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.List;
import java.util.Properties;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.services.io.FormatableIntHolder;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.KeyHasher;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.shared.common.error.StandardException;

class HashTableResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public long restrictionTime;
    public long projectionTime;
    public int hashtableSize;
    public Properties scanProperties;
    public NoPutResultSet source;
    public GeneratedMethod singleTableRestriction;
    public Qualifier[][] nextQualifiers;
    private GeneratedMethod projection;
    private int[] projectMapping;
    private boolean runTimeStatsOn;
    private ExecRow mappedResultRow;
    public boolean reuseResult;
    public int[] keyColumns;
    private boolean removeDuplicates;
    private long maxInMemoryRowCount;
    private int initialCapacity;
    private float loadFactor;
    private boolean skipNullKeyColumns;
    private boolean firstNext = true;
    private int numFetchedOnNext;
    private int entryVectorSize;
    private List entryVector;
    private boolean hashTableBuilt;
    private boolean firstIntoHashtable = true;
    private ExecRow nextCandidate;
    private ExecRow projRow;
    private BackingStoreHashtable ht;

    HashTableResultSet(NoPutResultSet noPutResultSet, Activation activation, GeneratedMethod generatedMethod, Qualifier[][] qualifierArray, GeneratedMethod generatedMethod2, int n, int n2, boolean bl, int n3, boolean bl2, long l, int n4, float f, boolean bl3, double d, double d2) throws StandardException {
        super(activation, n, d, d2);
        this.source = noPutResultSet;
        this.singleTableRestriction = generatedMethod;
        this.nextQualifiers = qualifierArray;
        this.projection = generatedMethod2;
        this.projectMapping = ((ReferencedColumnsDescriptorImpl)activation.getPreparedStatement().getSavedObject(n2)).getReferencedColumnPositions();
        FormatableArrayHolder formatableArrayHolder = (FormatableArrayHolder)activation.getPreparedStatement().getSavedObject(n3);
        FormatableIntHolder[] formatableIntHolderArray = (FormatableIntHolder[])formatableArrayHolder.getArray(FormatableIntHolder[].class);
        this.keyColumns = new int[formatableIntHolderArray.length];
        for (int i = 0; i < formatableIntHolderArray.length; ++i) {
            this.keyColumns[i] = formatableIntHolderArray[i].getInt();
        }
        this.reuseResult = bl;
        this.removeDuplicates = bl2;
        this.maxInMemoryRowCount = l;
        this.initialCapacity = n4;
        this.loadFactor = f;
        this.skipNullKeyColumns = bl3;
        if (this.projection == null) {
            this.mappedResultRow = this.activation.getExecutionFactory().getValueRow(this.projectMapping.length);
        }
        this.runTimeStatsOn = this.getLanguageConnectionContext().getRunTimeStatisticsMode();
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        TransactionController transactionController = this.activation.getTransactionController();
        if (!this.hashTableBuilt) {
            this.source.openCore();
            this.ht = new BackingStoreHashtable(transactionController, this, this.keyColumns, this.removeDuplicates, (int)this.optimizerEstimatedRowCount, this.maxInMemoryRowCount, this.initialCapacity, this.loadFactor, this.skipNullKeyColumns, false);
            if (this.runTimeStatsOn) {
                this.hashtableSize = this.ht.size();
                if (this.scanProperties == null) {
                    this.scanProperties = new Properties();
                }
                try {
                    if (this.ht != null) {
                        this.ht.getAllRuntimeStats(this.scanProperties);
                    }
                }
                catch (StandardException standardException) {
                    // empty catch block
                }
            }
            this.isOpen = true;
            this.hashTableBuilt = true;
        }
        this.resetProbeVariables();
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public void reopenCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        this.resetProbeVariables();
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    private void resetProbeVariables() throws StandardException {
        this.firstNext = true;
        this.numFetchedOnNext = 0;
        this.entryVector = null;
        this.entryVectorSize = 0;
        if (this.nextQualifiers != null) {
            this.clearOrderableCache(this.nextQualifiers);
        }
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.isXplainOnlyMode()) {
            return null;
        }
        ExecRow execRow = null;
        DataValueDescriptor[] dataValueDescriptorArray = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            do {
                if (this.firstNext) {
                    Object object;
                    this.firstNext = false;
                    if (this.keyColumns.length == 1) {
                        object = this.ht.get(this.nextQualifiers[0][0].getOrderable());
                    } else {
                        KeyHasher keyHasher = new KeyHasher(this.keyColumns.length);
                        for (int i = 0; i < this.keyColumns.length; ++i) {
                            keyHasher.setObject(i, this.nextQualifiers[0][i].getOrderable());
                        }
                        object = this.ht.get(keyHasher);
                    }
                    if (object instanceof List) {
                        this.entryVector = (List)object;
                        this.entryVectorSize = this.entryVector.size();
                        dataValueDescriptorArray = (DataValueDescriptor[])this.entryVector.get(0);
                    } else {
                        this.entryVector = null;
                        this.entryVectorSize = 0;
                        dataValueDescriptorArray = (DataValueDescriptor[])object;
                    }
                } else if (this.numFetchedOnNext < this.entryVectorSize) {
                    dataValueDescriptorArray = (DataValueDescriptor[])this.entryVector.get(this.numFetchedOnNext);
                }
                if (dataValueDescriptorArray != null) {
                    int n;
                    boolean bl = true;
                    for (n = 0; n < this.nextQualifiers[0].length; ++n) {
                        Qualifier qualifier = this.nextQualifiers[0][n];
                        bl = dataValueDescriptorArray[qualifier.getColumnId()].compare(qualifier.getOperator(), qualifier.getOrderable(), qualifier.getOrderedNulls(), qualifier.getUnknownRV());
                        if (qualifier.negateCompareResult()) {
                            boolean bl2 = bl = !bl;
                        }
                        if (!bl) break;
                    }
                    if (bl) {
                        for (n = 0; n < dataValueDescriptorArray.length; ++n) {
                            this.nextCandidate.setColumn(n + 1, dataValueDescriptorArray[n]);
                        }
                        execRow = this.doProjection(this.nextCandidate);
                    } else {
                        execRow = null;
                    }
                    ++this.numFetchedOnNext;
                    continue;
                }
                execRow = null;
            } while (execRow == null && this.numFetchedOnNext < this.entryVectorSize);
        }
        this.setCurrentRow(execRow);
        this.nextTime += this.getElapsedMillis(this.beginTime);
        if (this.runTimeStatsOn) {
            if (!this.isTopResultSet) {
                StatementContext statementContext = this.activation.getLanguageConnectionContext().getStatementContext();
                this.subqueryTrackingArray = statementContext.getSubqueryTrackingArray();
            }
            this.nextTime += this.getElapsedMillis(this.beginTime);
        }
        return execRow;
    }

    @Override
    public long getTimeSpent(int n) {
        long l = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (n == 0) {
            return l - this.source.getTimeSpent(1);
        }
        return l;
    }

    @Override
    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.source.close();
            super.close();
            if (this.hashTableBuilt) {
                this.ht.close();
                this.ht = null;
                this.hashTableBuilt = false;
            }
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        return ((CursorResultSet)((Object)this.source)).getRowLocation();
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        ExecRow execRow = null;
        ExecRow execRow2 = null;
        boolean bl = false;
        if (this.currentRow == null) {
            return null;
        }
        execRow = ((CursorResultSet)((Object)this.source)).getCurrentRow();
        if (execRow != null) {
            this.setCurrentRow(execRow);
            DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)(this.singleTableRestriction == null ? null : this.singleTableRestriction.invoke(this.activation));
            boolean bl2 = bl = dataValueDescriptor == null || !dataValueDescriptor.isNull() && dataValueDescriptor.getBoolean();
        }
        if (execRow != null && bl) {
            execRow2 = this.doProjection(execRow);
        }
        this.currentRow = execRow2;
        if (execRow2 == null) {
            this.clearCurrentRow();
        }
        return this.currentRow;
    }

    private ExecRow doProjection(ExecRow execRow) throws StandardException {
        if (this.reuseResult && this.projRow != null) {
            return this.projRow;
        }
        ExecRow execRow2 = this.projection != null ? (ExecRow)this.projection.invoke(this.activation) : this.mappedResultRow;
        for (int i = 0; i < this.projectMapping.length; ++i) {
            if (this.projectMapping[i] == -1) continue;
            execRow2.setColumn(i + 1, execRow.getColumn(this.projectMapping[i]));
        }
        this.setCurrentRow(execRow2);
        if (this.reuseResult) {
            this.projRow = execRow2;
        }
        return execRow2;
    }

    @Override
    public DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        ExecRow execRow = this.source.getNextRowCore();
        while (execRow != null) {
            boolean bl = false;
            ++this.rowsSeen;
            DataValueDescriptor dataValueDescriptor = (DataValueDescriptor)(this.singleTableRestriction == null ? null : this.singleTableRestriction.invoke(this.activation));
            boolean bl2 = bl = dataValueDescriptor == null || !dataValueDescriptor.isNull() && dataValueDescriptor.getBoolean();
            if (!bl) {
                execRow = this.source.getNextRowCore();
                continue;
            }
            if (this.targetResultSet != null) {
                this.clonedExecRow = this.targetResultSet.preprocessSourceRow(execRow);
            }
            if (this.firstIntoHashtable) {
                this.nextCandidate = this.activation.getExecutionFactory().getValueRow(execRow.nColumns());
                this.firstIntoHashtable = false;
            }
            return execRow.getRowArray();
        }
        return null;
    }

    @Override
    public boolean isForUpdate() {
        if (this.source == null) {
            return false;
        }
        return this.source.isForUpdate();
    }
}

