/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.util.collections;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import org.jboss.weld.util.Preconditions;
import org.jboss.weld.util.collections.ImmutableList;
import org.jboss.weld.util.collections.Iterators;

class ImmutableArrayList<E>
extends ImmutableList<E>
implements RandomAccess,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object[] elements;

    ImmutableArrayList(Object[] elements) {
        this.elements = elements;
    }

    @Override
    public E get(int index) {
        if (index < 0 || index >= this.size()) {
            throw this.indexOutOfBoundsException(index);
        }
        return (E)this.elements[index];
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public boolean contains(Object o) {
        Preconditions.checkNotNull(o);
        for (Object element : this.elements) {
            if (!o.equals(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int indexOf(Object o) {
        Preconditions.checkNotNull(o);
        for (int i = 0; i < this.elements.length; ++i) {
            if (!o.equals(this.elements[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        Preconditions.checkNotNull(o);
        for (int i = this.elements.length - 1; i >= 0; --i) {
            if (!o.equals(this.elements[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index < 0 || index > this.elements.length) {
            throw this.indexOutOfBoundsException(index);
        }
        return new ListIteratorImpl(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex > toIndex) {
            throw this.indexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this.elements.length) {
            throw this.indexOutOfBoundsException(toIndex);
        }
        if (fromIndex == toIndex) {
            return Collections.emptyList();
        }
        return new ImmutableArrayList<E>(Arrays.copyOfRange(this.elements, fromIndex, toIndex));
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (Object element : this.elements) {
            hashCode = 31 * hashCode + element.hashCode();
        }
        return hashCode;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elements, this.size());
    }

    @Override
    public <T> T[] toArray(T[] array) {
        if (array.length < this.size()) {
            return Arrays.copyOf(this.elements, this.size(), array.getClass());
        }
        System.arraycopy(this.elements, 0, array, 0, this.size());
        if (array.length > this.size()) {
            array[this.size()] = null;
        }
        return array;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < this.size(); ++i) {
            Object element = this.elements[i];
            sb.append(element == this ? "(this Collection)" : element);
            if (i + 1 >= this.size()) continue;
            sb.append(',').append(' ');
        }
        return sb.append(']').toString();
    }

    @Override
    public void forEach(Consumer<? super E> action) {
        Preconditions.checkNotNull(action);
        for (Object object : this.elements) {
            action.accept(object);
        }
    }

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this.elements, 1296);
    }

    private class ListIteratorImpl
    extends Iterators.IndexIterator<E> {
        ListIteratorImpl(int index) {
            super(ImmutableArrayList.this.size(), index);
        }

        @Override
        E getElement(int index) {
            return ImmutableArrayList.this.get(index);
        }
    }
}

