/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.build.compatible.spi.MethodConfig;
import jakarta.enterprise.inject.build.compatible.spi.ParameterConfig;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.configurator.AnnotatedConstructorConfigurator;
import jakarta.enterprise.inject.spi.configurator.AnnotatedParameterConfigurator;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.declarations.MethodInfo;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.weld.lite.extension.translator.AnnotationInfoImpl;
import org.jboss.weld.lite.extension.translator.AnnotationProxy;
import org.jboss.weld.lite.extension.translator.MethodInfoImpl;
import org.jboss.weld.lite.extension.translator.ParameterConfigImpl;

class MethodConstructorConfigImpl
implements MethodConfig {
    private final AnnotatedConstructorConfigurator<?> configurator;
    private final BeanManager bm;

    MethodConstructorConfigImpl(AnnotatedConstructorConfigurator<?> configurator, BeanManager bm) {
        this.configurator = configurator;
        this.bm = bm;
    }

    @Override
    public MethodInfo info() {
        return new MethodInfoImpl(this.configurator.getAnnotated(), this.bm);
    }

    @Override
    public MethodConfig addAnnotation(Class<? extends Annotation> annotationType) {
        this.configurator.add(AnnotationProxy.create(annotationType, Collections.emptyMap()));
        return this;
    }

    @Override
    public MethodConfig addAnnotation(AnnotationInfo annotation) {
        this.configurator.add(((AnnotationInfoImpl)annotation).annotation);
        return this;
    }

    @Override
    public MethodConfig addAnnotation(Annotation annotation) {
        this.configurator.add(annotation);
        return this;
    }

    @Override
    public MethodConfig removeAnnotation(Predicate<AnnotationInfo> predicate) {
        this.configurator.remove(annotation -> predicate.test(new AnnotationInfoImpl((Annotation)annotation, this.bm)));
        return this;
    }

    @Override
    public MethodConfig removeAllAnnotations() {
        this.configurator.removeAll();
        return this;
    }

    @Override
    public List<ParameterConfig> parameters() {
        return this.configurator.params().stream().map(annotatedParameterConfigurator -> new ParameterConfigImpl((AnnotatedParameterConfigurator<?>)annotatedParameterConfigurator, this.bm)).collect(Collectors.toList());
    }
}

