/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.deployment;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jboss.weld.bootstrap.api.CDI11Bootstrap;
import org.jboss.weld.bootstrap.spi.BeanDeploymentArchive;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.jboss.weld.environment.deployment.AbstractWeldBeanDeploymentArchive;
import org.jboss.weld.xml.BeansXmlParser;

public class WeldBeanDeploymentArchive
extends AbstractWeldBeanDeploymentArchive {
    private final Collection<String> beanClasses;
    private final Collection<Class<?>> loadedBeanClasses;
    private final Collection<String> knownClasses;
    private final BeansXml beansXml;
    private volatile Collection<BeanDeploymentArchive> accessibleBeanDeploymentArchives;

    public WeldBeanDeploymentArchive(String id, Collection<String> beanClasses, BeansXml beansXml, Set<WeldBeanDeploymentArchive> beanDeploymentArchives) {
        this(id, beanClasses, null, beansXml, beanDeploymentArchives, Collections.emptySet());
    }

    public WeldBeanDeploymentArchive(String id, Collection<String> beanClasses, Collection<String> knownClasses, BeansXml beansXml, Set<WeldBeanDeploymentArchive> accessibleBeanDeploymentArchives, Collection<Class<?>> loadedBeanClasses) {
        super(id);
        this.beanClasses = beanClasses;
        this.knownClasses = knownClasses;
        this.beansXml = beansXml;
        this.loadedBeanClasses = loadedBeanClasses;
        this.setAccessibleBeanDeploymentArchives(accessibleBeanDeploymentArchives);
    }

    public WeldBeanDeploymentArchive(String id, Collection<String> beanClasses, BeansXml beansXml) {
        this(id, beanClasses, beansXml, Collections.emptySet());
    }

    public WeldBeanDeploymentArchive(String id, Collection<String> beanClasses, Collection<String> knownClasses, BeansXml beansXml) {
        this(id, beanClasses, knownClasses, beansXml, Collections.emptySet(), Collections.emptySet());
    }

    @Override
    public Collection<String> getBeanClasses() {
        return Collections.unmodifiableCollection(this.beanClasses);
    }

    @Override
    public Collection<Class<?>> getLoadedBeanClasses() {
        return Collections.unmodifiableCollection(this.loadedBeanClasses);
    }

    @Override
    public Collection<String> getKnownClasses() {
        return this.knownClasses != null ? this.knownClasses : super.getKnownClasses();
    }

    @Override
    public Collection<BeanDeploymentArchive> getBeanDeploymentArchives() {
        return this.accessibleBeanDeploymentArchives;
    }

    @Override
    public BeansXml getBeansXml() {
        return this.beansXml;
    }

    public synchronized void setAccessibleBeanDeploymentArchives(Set<WeldBeanDeploymentArchive> beanDeploymentArchives) {
        this.accessibleBeanDeploymentArchives = Collections.unmodifiableSet(new HashSet<WeldBeanDeploymentArchive>(beanDeploymentArchives));
    }

    void addBeanClass(String className) {
        this.beanClasses.add(className);
    }

    public static <T extends BeanDeploymentArchive> WeldBeanDeploymentArchive merge(CDI11Bootstrap bootstrap, Iterable<T> archives) {
        BeansXml mergedBeansXml = BeansXmlParser.mergeExisting(archives, true);
        HashSet<String> beanClasses = new HashSet<String>();
        for (BeanDeploymentArchive archive : archives) {
            beanClasses.addAll(archive.getBeanClasses());
        }
        return new WeldBeanDeploymentArchive("flat", beanClasses, mergedBeansXml);
    }

    public boolean isEmpty() {
        return this.beanClasses.isEmpty() && this.loadedBeanClasses.isEmpty();
    }
}

