/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.bootstrap;

import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.spi.ObserverMethod;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.jboss.weld.bootstrap.UnsupportedObserverMethodException;
import org.jboss.weld.bootstrap.api.helpers.AbstractBootstrapService;
import org.jboss.weld.event.ContainerLifecycleEventObserverMethod;
import org.jboss.weld.resources.spi.ClassFileInfo;
import org.jboss.weld.resources.spi.ClassFileServices;
import org.jboss.weld.util.Types;
import org.jboss.weld.util.reflection.Reflections;

public class FastProcessAnnotatedTypeResolver
extends AbstractBootstrapService {
    private final Set<ContainerLifecycleEventObserverMethod<?>> catchAllObservers = new HashSet();
    private final Map<ContainerLifecycleEventObserverMethod<?>, Predicate<ClassFileInfo>> observers = new LinkedHashMap();

    public FastProcessAnnotatedTypeResolver(Iterable<ObserverMethod<?>> observers) throws UnsupportedObserverMethodException {
        for (ObserverMethod<?> o : observers) {
            Set<Annotation> qualifiers;
            if (!(o instanceof ContainerLifecycleEventObserverMethod) || !(qualifiers = o.getObservedQualifiers()).isEmpty() && (qualifiers.size() != 1 || !Any.class.equals(qualifiers.iterator().next().annotationType()))) continue;
            this.process((ContainerLifecycleEventObserverMethod)o, o.getObservedType());
        }
    }

    private void process(ContainerLifecycleEventObserverMethod<?> observer, Type observedType) throws UnsupportedObserverMethodException {
        if (Object.class.equals((Object)observedType)) {
            this.catchAllObservers.add(observer);
        } else if (ProcessAnnotatedType.class.equals((Object)observedType)) {
            this.catchAllObservers.add(observer);
        } else if (observedType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)observedType;
            if (ProcessAnnotatedType.class.equals((Object)type.getRawType())) {
                Type typeParameter = type.getActualTypeArguments()[0];
                if (typeParameter instanceof Class) {
                    this.observers.put(observer, new ExactTypePredicate(Reflections.getRawType(typeParameter)));
                } else {
                    if (typeParameter instanceof ParameterizedType) {
                        return;
                    }
                    if (typeParameter instanceof WildcardType) {
                        WildcardType wildCard = (WildcardType)typeParameter;
                        this.checkBounds(observer, wildCard.getUpperBounds());
                        this.observers.put(observer, CompositePredicate.assignable(Types.getRawTypes(wildCard.getUpperBounds())));
                    } else if (typeParameter instanceof TypeVariable) {
                        TypeVariable variable = (TypeVariable)typeParameter;
                        this.checkBounds(observer, variable.getBounds());
                        this.observers.put(observer, CompositePredicate.assignable(Types.getRawTypes(variable.getBounds())));
                    }
                }
            }
        } else if (observedType instanceof TypeVariable) {
            this.defaultRules(observer, observedType);
        }
    }

    private void checkBounds(ContainerLifecycleEventObserverMethod<?> observer, Type[] bounds) throws UnsupportedObserverMethodException {
        for (Type type : bounds) {
            if (type instanceof Class) continue;
            throw new UnsupportedObserverMethodException(observer);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void defaultRules(ContainerLifecycleEventObserverMethod<?> observer, Type observedType) throws UnsupportedObserverMethodException {
        if (ProcessAnnotatedType.class.equals((Object)observedType)) {
            this.catchAllObservers.add(observer);
            return;
        } else if (observedType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)observedType;
            if (!ProcessAnnotatedType.class.equals((Object)parameterizedType.getRawType())) return;
            Type argument = parameterizedType.getActualTypeArguments()[0];
            if (!(argument instanceof Class)) throw new UnsupportedObserverMethodException(observer);
            this.observers.put(observer, new ExactTypePredicate(Reflections.getRawType(argument)));
            return;
        } else {
            if (!(observedType instanceof TypeVariable)) return;
            TypeVariable typeVariable = (TypeVariable)observedType;
            if (Reflections.isUnboundedTypeVariable(observedType)) {
                this.catchAllObservers.add(observer);
                return;
            } else {
                if (typeVariable.getBounds().length != 1) return;
                this.defaultRules(observer, typeVariable.getBounds()[0]);
            }
        }
    }

    public Set<ContainerLifecycleEventObserverMethod<?>> resolveProcessAnnotatedTypeObservers(ClassFileServices classFileServices, String className) {
        HashSet result = new HashSet();
        result.addAll(this.catchAllObservers);
        ClassFileInfo classInfo = classFileServices.getClassFileInfo(className);
        for (Map.Entry<ContainerLifecycleEventObserverMethod<?>, Predicate<ClassFileInfo>> entry : this.observers.entrySet()) {
            ContainerLifecycleEventObserverMethod<?> observer = entry.getKey();
            if (!this.containsRequiredAnnotation(classInfo, observer) || !entry.getValue().test(classInfo)) continue;
            result.add(observer);
        }
        return result;
    }

    private boolean containsRequiredAnnotation(ClassFileInfo classInfo, ContainerLifecycleEventObserverMethod<?> observer) {
        if (observer.getRequiredAnnotations().isEmpty()) {
            return true;
        }
        for (Class<Annotation> annotation : observer.getRequiredAnnotations()) {
            if (!classInfo.containsAnnotation(annotation)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void cleanupAfterBoot() {
        this.catchAllObservers.clear();
        this.observers.clear();
    }

    private static class CompositePredicate
    implements Predicate<ClassFileInfo> {
        private final Predicate<ClassFileInfo>[] predicates;

        private static CompositePredicate assignable(Class<?>[] classes) {
            Predicate[] predicates = new Predicate[classes.length];
            for (int i = 0; i < classes.length; ++i) {
                predicates[i] = new AssignableToPredicate(classes[i]);
            }
            return new CompositePredicate(predicates);
        }

        public CompositePredicate(Predicate<ClassFileInfo>[] predicates) {
            this.predicates = predicates;
        }

        @Override
        public boolean test(ClassFileInfo input) {
            for (Predicate<ClassFileInfo> predicate : this.predicates) {
                if (predicate.test(input)) continue;
                return false;
            }
            return true;
        }
    }

    private static class AssignableToPredicate
    implements Predicate<ClassFileInfo> {
        private final Class<?> type;

        public AssignableToPredicate(Class<?> type) {
            this.type = type;
        }

        @Override
        public boolean test(ClassFileInfo input) {
            return input.isAssignableTo(this.type);
        }
    }

    private static class ExactTypePredicate
    implements Predicate<ClassFileInfo> {
        private final Class<?> type;

        public ExactTypePredicate(Class<?> type) {
            this.type = type;
        }

        @Override
        public boolean test(ClassFileInfo input) {
            return this.type.getName().equals(input.getClassName());
        }
    }
}

