/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.work;

import com.sun.enterprise.connectors.work.WorkManagerFactoryImpl;
import jakarta.resource.spi.work.ExecutionContext;
import jakarta.resource.spi.work.Work;
import jakarta.resource.spi.work.WorkException;
import jakarta.resource.spi.work.WorkListener;
import jakarta.resource.spi.work.WorkManager;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class WorkManagerProxy
implements WorkManager,
Externalizable {
    private transient WorkManager wm;
    private String moduleName;

    public WorkManagerProxy(WorkManager wm, String moduleName) {
        this.wm = wm;
        this.moduleName = moduleName;
    }

    public WorkManagerProxy() {
    }

    public void doWork(Work work) throws WorkException {
        this.wm.doWork(work);
    }

    public void doWork(Work work, long startTimeout, ExecutionContext executionContext, WorkListener workListener) throws WorkException {
        this.wm.doWork(work, startTimeout, executionContext, workListener);
    }

    public long startWork(Work work) throws WorkException {
        return this.wm.startWork(work);
    }

    public long startWork(Work work, long startTimeout, ExecutionContext executionContext, WorkListener workListener) throws WorkException {
        return this.wm.startWork(work, startTimeout, executionContext, workListener);
    }

    public void scheduleWork(Work work) throws WorkException {
        this.wm.scheduleWork(work);
    }

    public void scheduleWork(Work work, long startTimeout, ExecutionContext executionContext, WorkListener workListener) throws WorkException {
        this.wm.scheduleWork(work, startTimeout, executionContext, workListener);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.moduleName);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.moduleName = in.readUTF();
        this.wm = WorkManagerFactoryImpl.retrieveWorkManager(this.moduleName);
    }

    public boolean equals(Object o) {
        boolean equal = false;
        if (o instanceof WorkManagerProxy) {
            WorkManagerProxy wmp = (WorkManagerProxy)o;
            equal = wmp.wm.equals(this.wm);
        }
        return equal;
    }

    public int hashCode() {
        return this.wm.hashCode();
    }
}

