/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.theme;

import com.sun.webui.theme.JarThemeFactory;
import com.sun.webui.theme.ThemeFactory;
import java.util.Locale;
import java.util.Set;

public abstract class ThemeContext {
    public static final int NOVERSION = -1;
    private static final String DOT = "\\.";
    public static final String THEME_MESSAGES = "com.sun.webui.theme.THEME_MESSAGES";
    private String messages;
    public static final String SUPPORTED_LOCALES = "com.sun.webui.theme.SUPPORTED_LOCALES";
    protected static final String LOCALE_SEPARATOR = ",";
    private Set supportedLocales;
    protected static final String THEME_CONTEXT = "com.sun.webui.theme.THEME_CONTEXT";
    protected static final String DEFAULT_LOCALE = "com.sun.webui.theme.DEFAULT_LOCALE";
    protected static final String DEFAULT_THEME = "com.sun.webui.theme.DEFAULT_THEME";
    protected static final String DEFAULT_THEME_VERSION = "com.sun.webui.theme.DEFAULT_THEME_VERSION";
    protected static final String THEME_RESOURCES = "com.sun.webui.theme.THEME_RESOURCES";
    protected static final String THEME_FACTORY_CLASS_NAME = "com.sun.webui.theme.THEME_FACTORY_CLASS_NAME";
    protected static final String THEME_SERVLET_CONTEXT = "com.sun.webui.theme.THEME_SERVLET_CONTEXT";
    private Locale defaultLocale = Locale.getDefault();
    private String defaultTheme = null;
    private String defaultThemeVersion = null;
    private String themeServletContext;
    private String[] themeResources;
    private String themeFactoryClassName;
    private ClassLoader defaultClassLoader;
    private String requestContextPath;
    private ThemeFactory themeFactory;

    ThemeContext() {
    }

    public String getMessages() {
        return this.messages;
    }

    public final void setMessages(String newMessages) {
        this.messages = newMessages;
    }

    public Set getSupportedLocales() {
        return this.supportedLocales;
    }

    public final void setSupportedLocales(Set newSupportedLocales) {
        this.supportedLocales = newSupportedLocales;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ThemeFactory getThemeFactory() {
        ThemeContext themeContext = this;
        synchronized (themeContext) {
            if (this.themeFactory == null) {
                try {
                    this.themeFactory = (ThemeFactory)Class.forName(this.getThemeFactoryClassName()).newInstance();
                }
                catch (Exception e) {
                    return new JarThemeFactory();
                }
            }
        }
        return this.themeFactory;
    }

    public String[] getThemeResources() {
        return this.themeResources;
    }

    public final void setThemeResources(String[] newThemeResources) {
        this.themeResources = newThemeResources;
    }

    public String getRequestContextPath() {
        return this.requestContextPath;
    }

    public void setRequestContextPath(String newReqContextPath) {
        this.requestContextPath = newReqContextPath;
    }

    public String getResourcePath(String path) {
        String res = this.getRequestContextPath() + this.getThemeServletContext();
        if (!path.startsWith("/")) {
            return res + "/" + res;
        }
        return res + path;
    }

    public final void setDefaultLocale(String newDefaultLocale) {
        this.defaultLocale = ThemeContext.getLocale(newDefaultLocale);
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public ClassLoader getDefaultClassLoader() {
        if (this.defaultClassLoader == null) {
            return this.getClass().getClassLoader();
        }
        return this.defaultClassLoader;
    }

    public void setDefaultClassLoader(ClassLoader newDefaultClassLoader) {
        this.defaultClassLoader = newDefaultClassLoader;
    }

    public String getThemeFactoryClassName() {
        return this.themeFactoryClassName;
    }

    public final void setThemeFactoryClassName(String newThemeFactoryClassName) {
        this.themeFactoryClassName = newThemeFactoryClassName;
    }

    public String getDefaultTheme() {
        return this.defaultTheme;
    }

    public final void setDefaultTheme(String newDefaultTheme) {
        this.defaultTheme = newDefaultTheme;
    }

    public String getDefaultThemeVersion() {
        return this.defaultThemeVersion;
    }

    public final void setDefaultThemeVersion(String newDefaultThemeVersion) {
        this.defaultThemeVersion = newDefaultThemeVersion;
    }

    public String getThemeServletContext() {
        return this.themeServletContext;
    }

    public final void setThemeServletContext(String newThemeServletContext) {
        this.themeServletContext = newThemeServletContext;
    }

    public int getDefaultThemeMajorVersion() {
        return this.getVersionNumber(Version.MAJOR);
    }

    public int getDefaultThemeMinorVersion() {
        return this.getVersionNumber(Version.MINOR);
    }

    private int getVersionNumber(Version majorOrMinor) {
        int version = -1;
        if (this.getDefaultThemeVersion() == null) {
            return -1;
        }
        try {
            String[] majmin = this.getDefaultThemeVersion().split(DOT);
            switch (majorOrMinor) {
                case MAJOR: {
                    version = Integer.parseInt(majmin[0]);
                    break;
                }
                case MINOR: {
                    version = Integer.parseInt(majmin[1]);
                    break;
                }
                default: {
                    version = -1;
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return version;
    }

    private static Locale getLocale(String localeString) {
        if (localeString == null) {
            return null;
        }
        String localeStr = localeString.trim();
        if (localeStr.length() == 0) {
            return null;
        }
        Locale locale = null;
        String[] strings = localeStr.split("_");
        if (strings.length > 2) {
            locale = new Locale(strings[0], strings[1], strings[2]);
        } else if (strings.length > 1) {
            locale = new Locale(strings[0], strings[1]);
        } else if (strings.length > 0) {
            locale = new Locale(strings[0]);
        }
        return locale;
    }

    private static enum Version {
        MAJOR,
        MINOR;

    }
}

