/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import com.sun.webui.jsf.util.TypeConversion;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public final class TypeConverter {
    private static final Map<Object, TypeConversion> TYPE_CONVERSIONS = new HashMap<Object, TypeConversion>();
    public static final String TYPE_UNKNOWN = "null";
    public static final String TYPE_OBJECT = "object";
    public static final String TYPE_STRING = "string";
    public static final String TYPE_INT = "int";
    public static final String TYPE_INTEGER = "integer";
    public static final String TYPE_LONG = "long";
    public static final String TYPE_FLOAT = "float";
    public static final String TYPE_DOUBLE = "double";
    public static final String TYPE_SHORT = "short";
    public static final String TYPE_BOOLEAN = "boolean";
    public static final String TYPE_BYTE = "byte";
    public static final String TYPE_CHAR = "char";
    public static final String TYPE_CHARACTER = "character";
    public static final String TYPE_BIG_DECIMAL = "bigdecimal";
    public static final String TYPE_SQL_DATE = "sqldate";
    public static final String TYPE_SQL_TIME = "sqltime";
    public static final String TYPE_SQL_TIMESTAMP = "sqltimestamp";
    private static final TypeConversion UNKNOWN_TYPE_CONVERSION = new UnknownTypeConversion();
    private static final TypeConversion OBJECT_TYPE_CONVERSION = new ObjectTypeConversion();
    private static final TypeConversion STRING_TYPE_CONVERSION = new StringTypeConversion();
    private static final TypeConversion INTEGER_TYPE_CONVERSION = new IntegerTypeConversion();
    private static final TypeConversion DOUBLE_TYPE_CONVERSION = new DoubleTypeConversion();
    private static final TypeConversion BOOLEAN_TYPE_CONVERSION = new BooleanTypeConversion();
    private static final TypeConversion LONG_TYPE_CONVERSION = new LongTypeConversion();
    private static final TypeConversion FLOAT_TYPE_CONVERSION = new FloatTypeConversion();
    private static final TypeConversion SHORT_TYPE_CONVERSION = new ShortTypeConversion();
    private static final TypeConversion BIG_DECIMAL_TYPE_CONVERSION = new BigDecimalTypeConversion();
    private static final TypeConversion BYTE_TYPE_CONVERSION = new ByteTypeConversion();
    private static final TypeConversion CHARACTER_TYPE_CONVERSION = new CharacterTypeConversion();
    private static final TypeConversion SQL_DATE_TYPE_CONVERSION = new SqlDateTypeConversion();
    private static final TypeConversion SQL_TIME_TYPE_CONVERSION = new SqlTimeTypeConversion();
    private static final TypeConversion SQL_TIMESTAMP_TYPE_CONVERSION = new SqlTimestampTypeConversion();

    private TypeConverter() {
    }

    public static Map<Object, TypeConversion> getTypeConversions() {
        return TYPE_CONVERSIONS;
    }

    private static void registerTypeConversion(Object key, TypeConversion conversion) {
        TYPE_CONVERSIONS.put(key, conversion);
    }

    private static Object asType(Object typeKey, Object value) {
        if (value == null) {
            return null;
        }
        if (typeKey == null) {
            return value;
        }
        if (typeKey instanceof Class && (Class)typeKey != Object.class && ((Class)typeKey).isInstance(value)) {
            return value;
        }
        TypeConversion conversion = TYPE_CONVERSIONS.get(typeKey);
        if (conversion != null) {
            return conversion.convertValue(value);
        }
        throw new IllegalArgumentException("Could not find type conversion for type \"" + typeKey + "\" (value = \"" + value + "\"");
    }

    public static byte asByte(Object value) {
        return TypeConverter.asByte(value, (byte)0);
    }

    public static byte asByte(Object value, byte defaultValue) {
        Object res = TypeConverter.asType(Byte.class, value);
        if (res != null) {
            return (Byte)res;
        }
        return defaultValue;
    }

    public static short asShort(Object value) {
        return TypeConverter.asShort(value, (short)0);
    }

    public static short asShort(Object value, short defaultValue) {
        Object res = TypeConverter.asType(Short.class, value);
        if (res != null) {
            return (Short)res;
        }
        return defaultValue;
    }

    public static int asInt(Object value) {
        return TypeConverter.asInt(value, 0);
    }

    public static int asInt(Object value, int defaultValue) {
        Object res = TypeConverter.asType(Integer.class, value);
        if (res != null) {
            return (Integer)res;
        }
        return defaultValue;
    }

    public static long asLong(Object value) {
        return TypeConverter.asLong(value, 0L);
    }

    public static long asLong(Object value, long defaultValue) {
        Object res = TypeConverter.asType(Long.class, value);
        if (res != null) {
            return (Long)res;
        }
        return defaultValue;
    }

    public static float asFloat(Object value) {
        return TypeConverter.asFloat(value, 0.0f);
    }

    public static float asFloat(Object value, float defaultValue) {
        Object res = TypeConverter.asType(Float.class, value);
        if (res != null) {
            return ((Float)res).floatValue();
        }
        return defaultValue;
    }

    public static double asDouble(Object value) {
        return TypeConverter.asDouble(value, 0.0);
    }

    public static double asDouble(Object value, double defaultValue) {
        Object res = TypeConverter.asType(Double.class, value);
        if (res != null) {
            return (Double)res;
        }
        return defaultValue;
    }

    public static char asChar(Object value) {
        return TypeConverter.asChar(value, '\u0000');
    }

    public static char asChar(Object value, char defaultValue) {
        Object res = TypeConverter.asType(Character.class, value);
        if (res != null) {
            return ((Character)res).charValue();
        }
        return defaultValue;
    }

    public static boolean asBoolean(Object value) {
        return TypeConverter.asBoolean(value, false);
    }

    public static boolean asBoolean(Object value, boolean defaultValue) {
        Object res = TypeConverter.asType(Boolean.class, value);
        if (res != null) {
            return (Boolean)res;
        }
        return defaultValue;
    }

    public static String asString(Object value) {
        return (String)TypeConverter.asType(String.class, value);
    }

    public static String asString(Object value, String defaultValue) {
        Object res = TypeConverter.asType(String.class, value);
        if (res != null) {
            return (String)res;
        }
        return defaultValue;
    }

    static {
        TypeConverter.registerTypeConversion(Object.class, OBJECT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(String.class, STRING_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Integer.class, INTEGER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Integer.TYPE, INTEGER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Double.class, DOUBLE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Double.TYPE, DOUBLE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Boolean.class, BOOLEAN_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Boolean.TYPE, BOOLEAN_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Long.class, LONG_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Long.TYPE, LONG_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Float.class, FLOAT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Float.TYPE, FLOAT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Short.class, SHORT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Short.TYPE, SHORT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(BigDecimal.class, BIG_DECIMAL_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Byte.class, BYTE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Byte.TYPE, BYTE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Character.class, CHARACTER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Character.TYPE, CHARACTER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Date.class, SQL_DATE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Time.class, SQL_TIME_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Timestamp.class, SQL_TIMESTAMP_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Object.class.getName(), OBJECT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(String.class.getName(), STRING_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Integer.class.getName(), INTEGER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Double.class.getName(), DOUBLE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Boolean.class.getName(), BOOLEAN_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Long.class.getName(), LONG_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Float.class.getName(), FLOAT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Short.class.getName(), SHORT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(BigDecimal.class.getName(), BIG_DECIMAL_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Byte.class.getName(), BYTE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Character.class.getName(), CHARACTER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Date.class.getName(), SQL_DATE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Time.class.getName(), SQL_TIME_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(Timestamp.class.getName(), SQL_TIMESTAMP_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_UNKNOWN, UNKNOWN_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_OBJECT, OBJECT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_STRING, STRING_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_INT, INTEGER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_INTEGER, INTEGER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_DOUBLE, DOUBLE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_BOOLEAN, BOOLEAN_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_LONG, LONG_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_FLOAT, FLOAT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_SHORT, SHORT_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_BIG_DECIMAL, BIG_DECIMAL_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_BYTE, BYTE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_CHAR, CHARACTER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_CHARACTER, CHARACTER_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_SQL_DATE, SQL_DATE_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_SQL_TIME, SQL_TIME_TYPE_CONVERSION);
        TypeConverter.registerTypeConversion(TYPE_SQL_TIMESTAMP, SQL_TIMESTAMP_TYPE_CONVERSION);
    }

    private static final class ObjectTypeConversion
    implements TypeConversion {
        private ObjectTypeConversion() {
        }

        @Override
        public Object convertValue(Object value) {
            return value;
        }
    }

    private static final class SqlTimestampTypeConversion
    implements TypeConversion {
        private SqlTimestampTypeConversion() {
        }

        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Timestamp)) {
                String v = value.toString();
                if (v.trim().length() == 0) {
                    return null;
                }
                return Timestamp.valueOf(v);
            }
            return value;
        }
    }

    private static final class SqlTimeTypeConversion
    implements TypeConversion {
        private SqlTimeTypeConversion() {
        }

        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Time)) {
                String v = value.toString();
                if (v.trim().length() == 0) {
                    return null;
                }
                return Time.valueOf(v);
            }
            return value;
        }
    }

    private static final class SqlDateTypeConversion
    implements TypeConversion {
        private SqlDateTypeConversion() {
        }

        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Date)) {
                String v = value.toString();
                if (v.trim().length() == 0) {
                    return null;
                }
                return Date.valueOf(v);
            }
            return value;
        }
    }

    private static final class CharacterTypeConversion
    implements TypeConversion {
        private CharacterTypeConversion() {
        }

        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Character)) {
                String v = value.toString();
                if (v.trim().length() == 0) {
                    return null;
                }
                return Character.valueOf(v.charAt(0));
            }
            return value;
        }
    }

    private static final class ByteTypeConversion
    implements TypeConversion {
        private ByteTypeConversion() {
        }

        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Byte)) {
                String v = value.toString();
                if (v.trim().length() == 0) {
                    return null;
                }
                return new Byte(v);
            }
            return value;
        }
    }

    private static final class BigDecimalTypeConversion
    implements TypeConversion {
        private BigDecimalTypeConversion() {
        }

        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof BigDecimal)) {
                String v = value.toString();
                if (v.trim().length() == 0) {
                    return null;
                }
                return new BigDecimal(v);
            }
            return value;
        }
    }

    private static final class ShortTypeConversion
    implements TypeConversion {
        private ShortTypeConversion() {
        }

        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Short)) {
                String v = value.toString();
                if (v.trim().length() == 0) {
                    return null;
                }
                return new Short(v);
            }
            return value;
        }
    }

    private static final class FloatTypeConversion
    implements TypeConversion {
        private FloatTypeConversion() {
        }

        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Float)) {
                String v = value.toString();
                if (v.trim().length() == 0) {
                    return null;
                }
                return new Float(v);
            }
            return value;
        }
    }

    private static final class LongTypeConversion
    implements TypeConversion {
        private LongTypeConversion() {
        }

        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Long)) {
                String v = value.toString();
                if (v.trim().length() == 0) {
                    return null;
                }
                return new Long(v);
            }
            return value;
        }
    }

    private static final class BooleanTypeConversion
    implements TypeConversion {
        private BooleanTypeConversion() {
        }

        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Boolean)) {
                String v = value.toString();
                if (v.trim().length() == 0) {
                    return null;
                }
                return Boolean.valueOf(v);
            }
            return value;
        }
    }

    private static final class DoubleTypeConversion
    implements TypeConversion {
        private DoubleTypeConversion() {
        }

        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Double)) {
                String v = value.toString();
                if (v.trim().length() == 0) {
                    return null;
                }
                return new Double(v);
            }
            return value;
        }
    }

    private static final class IntegerTypeConversion
    implements TypeConversion {
        private IntegerTypeConversion() {
        }

        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (!(value instanceof Integer)) {
                String v = value.toString();
                if (v.trim().length() == 0) {
                    return null;
                }
                return new Integer(v);
            }
            return value;
        }
    }

    private static final class StringTypeConversion
    implements TypeConversion {
        private StringTypeConversion() {
        }

        @Override
        public Object convertValue(Object value) {
            if (value == null) {
                return null;
            }
            if (value.getClass().isArray()) {
                if (value.getClass().getComponentType() == Byte.TYPE) {
                    return new String((byte[])value);
                }
                if (value.getClass().getComponentType() == Character.TYPE) {
                    return new String((char[])value);
                }
            } else if (!(value instanceof String)) {
                return value.toString();
            }
            return value;
        }
    }

    private static final class UnknownTypeConversion
    implements TypeConversion {
        private UnknownTypeConversion() {
        }

        @Override
        public Object convertValue(Object value) {
            return value;
        }
    }
}

