/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.listener;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.email.EmailAddress;
import org.apache.tools.ant.taskdefs.email.Header;
import org.apache.tools.ant.taskdefs.email.Mailer;
import org.apache.tools.ant.taskdefs.email.Message;
import org.apache.tools.ant.util.ClasspathUtils;
import org.apache.tools.ant.util.DateUtils;
import org.apache.tools.ant.util.FileUtils;
import org.apache.tools.ant.util.StringUtils;
import org.apache.tools.mail.MailMessage;

public class MailLogger
extends DefaultLogger {
    private StringBuffer buffer = new StringBuffer();
    private static final String DEFAULT_MIME_TYPE = "text/plain";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void buildFinished(BuildEvent event) {
        super.buildFinished(event);
        Project project = event.getProject();
        Hashtable<String, Object> properties = project.getProperties();
        Properties fileProperties = new Properties();
        String filename = (String)properties.get("MailLogger.properties.file");
        if (filename != null) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(filename);
                fileProperties.load(is);
            }
            catch (IOException iOException) {
                FileUtils.close(is);
                catch (Throwable throwable) {
                    FileUtils.close(is);
                    throw throwable;
                }
            }
            FileUtils.close(is);
        }
        Enumeration<Object> e = fileProperties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = fileProperties.getProperty(key);
            properties.put(key, project.replaceProperties(value));
        }
        boolean success = event.getException() == null;
        String prefix = success ? "success" : "failure";
        try {
            boolean notify = Project.toBoolean(this.getValue(properties, prefix + ".notify", "on"));
            if (!notify) {
                return;
            }
            Values values = new Values().mailhost(this.getValue(properties, "mailhost", "localhost")).port(Integer.parseInt(this.getValue(properties, "port", String.valueOf(25)))).user(this.getValue(properties, "user", "")).password(this.getValue(properties, "password", "")).ssl(Project.toBoolean(this.getValue(properties, "ssl", "off"))).starttls(Project.toBoolean(this.getValue(properties, "starttls.enable", "off"))).from(this.getValue(properties, "from", null)).replytoList(this.getValue(properties, "replyto", "")).toList(this.getValue(properties, prefix + ".to", null)).toCcList(this.getValue(properties, prefix + ".cc", "")).toBccList(this.getValue(properties, prefix + ".bcc", "")).mimeType(this.getValue(properties, "mimeType", DEFAULT_MIME_TYPE)).charset(this.getValue(properties, "charset", "")).body(this.getValue(properties, prefix + ".body", "")).subject(this.getValue(properties, prefix + ".subject", success ? "Build Success" : "Build Failure"));
            if (values.user().equals("") && values.password().equals("") && !values.ssl() && !values.starttls()) {
                this.sendMail(values, this.buffer.substring(0));
            } else {
                this.sendMimeMail(event.getProject(), values, this.buffer.substring(0));
            }
        }
        catch (Exception e2) {
            System.out.println("MailLogger failed to send e-mail!");
            e2.printStackTrace(System.err);
        }
    }

    @Override
    protected void log(String message) {
        this.buffer.append(message).append(StringUtils.LINE_SEP);
    }

    private String getValue(Hashtable<String, Object> properties, String name, String defaultValue) {
        String propertyName = "MailLogger." + name;
        String value = (String)properties.get(propertyName);
        if (value == null) {
            value = defaultValue;
        }
        if (value == null) {
            throw new RuntimeException("Missing required parameter: " + propertyName);
        }
        return value;
    }

    private void sendMail(Values values, String message) throws IOException {
        StringTokenizer t;
        MailMessage mailMessage = new MailMessage(values.mailhost(), values.port());
        mailMessage.setHeader("Date", DateUtils.getDateForHeader());
        mailMessage.from(values.from());
        if (!values.replytoList().equals("")) {
            t = new StringTokenizer(values.replytoList(), ", ", false);
            while (t.hasMoreTokens()) {
                mailMessage.replyto(t.nextToken());
            }
        }
        t = new StringTokenizer(values.toList(), ", ", false);
        while (t.hasMoreTokens()) {
            mailMessage.to(t.nextToken());
        }
        mailMessage.setSubject(values.subject());
        if (values.charset().length() > 0) {
            mailMessage.setHeader("Content-Type", values.mimeType() + "; charset=\"" + values.charset() + "\"");
        } else {
            mailMessage.setHeader("Content-Type", values.mimeType());
        }
        PrintStream ps = mailMessage.getPrintStream();
        ps.println(values.body().length() > 0 ? values.body() : message);
        mailMessage.sendAndClose();
    }

    private void sendMimeMail(Project project, Values values, String message) {
        Mailer mailer = null;
        try {
            mailer = (Mailer)ClasspathUtils.newInstance("org.apache.tools.ant.taskdefs.email.MimeMailer", MailLogger.class.getClassLoader(), Mailer.class);
        }
        catch (BuildException e) {
            Throwable t = e.getCause() == null ? e : e.getCause();
            this.log("Failed to initialise MIME mail: " + t.getMessage());
            return;
        }
        Vector<EmailAddress> replyToList = this.vectorizeEmailAddresses(values.replytoList());
        mailer.setHost(values.mailhost());
        mailer.setPort(values.port());
        mailer.setUser(values.user());
        mailer.setPassword(values.password());
        mailer.setSSL(values.ssl());
        mailer.setEnableStartTLS(values.starttls());
        Message mymessage = new Message(values.body().length() > 0 ? values.body() : message);
        mymessage.setProject(project);
        mymessage.setMimeType(values.mimeType());
        if (values.charset().length() > 0) {
            mymessage.setCharset(values.charset());
        }
        mailer.setMessage(mymessage);
        mailer.setFrom(new EmailAddress(values.from()));
        mailer.setReplyToList(replyToList);
        Vector<EmailAddress> toList = this.vectorizeEmailAddresses(values.toList());
        mailer.setToList(toList);
        Vector<EmailAddress> toCcList = this.vectorizeEmailAddresses(values.toCcList());
        mailer.setCcList(toCcList);
        Vector<EmailAddress> toBccList = this.vectorizeEmailAddresses(values.toBccList());
        mailer.setBccList(toBccList);
        mailer.setFiles(new Vector<File>());
        mailer.setSubject(values.subject());
        mailer.setHeaders(new Vector<Header>());
        mailer.send();
    }

    private Vector<EmailAddress> vectorizeEmailAddresses(String listString) {
        Vector<EmailAddress> emailList = new Vector<EmailAddress>();
        StringTokenizer tokens = new StringTokenizer(listString, ",");
        while (tokens.hasMoreTokens()) {
            emailList.addElement(new EmailAddress(tokens.nextToken()));
        }
        return emailList;
    }

    private static class Values {
        private String mailhost;
        private int port;
        private String user;
        private String password;
        private boolean ssl;
        private String from;
        private String replytoList;
        private String toList;
        private String toCcList;
        private String toBccList;
        private String subject;
        private String charset;
        private String mimeType;
        private String body;
        private boolean starttls;

        private Values() {
        }

        public String mailhost() {
            return this.mailhost;
        }

        public Values mailhost(String mailhost) {
            this.mailhost = mailhost;
            return this;
        }

        public int port() {
            return this.port;
        }

        public Values port(int port) {
            this.port = port;
            return this;
        }

        public String user() {
            return this.user;
        }

        public Values user(String user) {
            this.user = user;
            return this;
        }

        public String password() {
            return this.password;
        }

        public Values password(String password) {
            this.password = password;
            return this;
        }

        public boolean ssl() {
            return this.ssl;
        }

        public Values ssl(boolean ssl) {
            this.ssl = ssl;
            return this;
        }

        public String from() {
            return this.from;
        }

        public Values from(String from) {
            this.from = from;
            return this;
        }

        public String replytoList() {
            return this.replytoList;
        }

        public Values replytoList(String replytoList) {
            this.replytoList = replytoList;
            return this;
        }

        public String toList() {
            return this.toList;
        }

        public Values toList(String toList) {
            this.toList = toList;
            return this;
        }

        public String toCcList() {
            return this.toCcList;
        }

        public Values toCcList(String toCcList) {
            this.toCcList = toCcList;
            return this;
        }

        public String toBccList() {
            return this.toBccList;
        }

        public Values toBccList(String toBccList) {
            this.toBccList = toBccList;
            return this;
        }

        public String subject() {
            return this.subject;
        }

        public Values subject(String subject) {
            this.subject = subject;
            return this;
        }

        public String charset() {
            return this.charset;
        }

        public Values charset(String charset) {
            this.charset = charset;
            return this;
        }

        public String mimeType() {
            return this.mimeType;
        }

        public Values mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public String body() {
            return this.body;
        }

        public Values body(String body) {
            this.body = body;
            return this;
        }

        public boolean starttls() {
            return this.starttls;
        }

        public Values starttls(boolean starttls) {
            this.starttls = starttls;
            return this;
        }
    }
}

