/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am.stmtcache;

public class StatementKey {
    private final boolean isCallableStatement;
    private final String sql;
    private final String schema;
    private final int type;
    private final int concurrency;
    private final int holdability;
    private final int autogeneratedKeys;

    StatementKey(boolean bl, String string, String string2, int n, int n2, int n3, int n4) {
        if (string2 == null) {
            throw new IllegalArgumentException("schema is <null>");
        }
        this.isCallableStatement = bl;
        this.sql = string;
        this.schema = string2;
        this.type = n;
        this.concurrency = n2;
        this.holdability = n3;
        this.autogeneratedKeys = n4;
    }

    public boolean equals(Object object) {
        if (!(object instanceof StatementKey)) {
            return false;
        }
        StatementKey statementKey = (StatementKey)object;
        if (this.holdability != statementKey.holdability) {
            return false;
        }
        if (this.autogeneratedKeys != statementKey.autogeneratedKeys) {
            return false;
        }
        if (this.isCallableStatement != statementKey.isCallableStatement) {
            return false;
        }
        if (!this.schema.equals(statementKey.schema)) {
            return false;
        }
        if (this.sql == null && statementKey.sql != null) {
            return false;
        }
        if (!this.sql.equals(statementKey.sql)) {
            return false;
        }
        if (this.type != statementKey.type) {
            return false;
        }
        return this.concurrency == statementKey.concurrency;
    }

    public int hashCode() {
        int n = 7;
        n = 47 * n + (this.isCallableStatement ? 1 : 0);
        n = 47 * n + (this.sql == null ? 3 : this.sql.hashCode());
        n = 47 * n + this.schema.hashCode();
        n = 47 * n + this.type;
        n = 47 * n + this.concurrency;
        n = 47 * n + this.holdability;
        n = 47 * n + this.autogeneratedKeys;
        return n;
    }

    public String toString() {
        return "'" + this.sql + "' in '" + this.schema + "', rsh = " + this.holdability + ", rst = " + this.type + ", rsc = " + this.concurrency + ", autogenKeys = " + this.autogeneratedKeys + ", isCallableStatement = " + this.isCallableStatement;
    }
}

