/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.optional.dump;

import java.io.File;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.derby.catalog.TypeDescriptor;
import org.apache.derby.iapi.sql.dictionary.OptionalTool;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.optional.dump.DataFileVTI;
import org.apache.derby.tools.dblook;

public class RawDBReader
implements OptionalTool {
    public void loadTool(String ... stringArray) throws SQLException {
        if (stringArray == null || stringArray.length < 7) {
            throw this.badArgs("Wrong number of arguments.");
        }
        int n = 0;
        String string = stringArray[n++];
        String string2 = stringArray[n++];
        String string3 = stringArray[n++];
        String string4 = stringArray[n++];
        String string5 = stringArray[n++];
        String string6 = stringArray[n++];
        String string7 = stringArray[n++];
        if (this.nullOrEmpty(string)) {
            throw this.badArgs("Null or empty recovery script argument.");
        }
        if (this.nullOrEmpty(string2)) {
            throw this.badArgs("Null or empty control schema argument.");
        }
        if (this.nullOrEmpty(string3)) {
            throw this.badArgs("Null or empty schema prefix argument.");
        }
        if (this.nullOrEmpty(string4)) {
            throw this.badArgs("Null or empty database location argument.");
        }
        if (this.nullOrEmpty(string6)) {
            throw this.badArgs("Null or empty database owner argument.");
        }
        Connection connection = this.getDerbyConnection();
        this.createControlSchema(connection, string2, string4, string5, string6, string7);
        this.createUserSchemas(connection, string2, string3, string4, string5, string6, string7);
        this.createViews(connection, string, string2, string3, string4, string5, string6, string7);
    }

    private boolean nullOrEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public void unloadTool(String ... stringArray) throws SQLException {
        if (stringArray == null || stringArray.length < 2) {
            throw this.badArgs("Wrong number of arguments.");
        }
        int n = 0;
        String string = stringArray[n++];
        String string2 = stringArray[n++];
        if (this.nullOrEmpty(string)) {
            throw this.badArgs("Null or empty control schema argument.");
        }
        if (this.nullOrEmpty(string2)) {
            throw this.badArgs("Null or empty schema prefix argument.");
        }
        Connection connection = this.getDerbyConnection();
        this.dropViews(connection, string2);
        this.dropUserSchemas(connection, string2);
        this.dropControlSchema(connection, string);
    }

    private SQLException badArgs(String string) {
        return new SQLException(string);
    }

    private void createControlSchema(Connection connection, String string, String string2, String string3, String string4, String string5) throws SQLException {
        this.executeDDL(connection, "create schema " + string);
        this.executeDDL(connection, "set schema " + string);
        this.executeDDL(connection, "create type serializable external name 'java.io.Serializable' language java");
        this.createTable(connection, string, "SYSCONGLOMERATES", "( schemaid char(36), tableid char(36), conglomeratenumber bigint, conglomeratename varchar( 128), isindex boolean, descriptor serializable, isconstant boolean, conglomerateid char( 36 ) )", "c20.dat", string2, string3, string4, string5);
        this.createTable(connection, string, "SYSCOLUMNS", "( referenceid char(36), columnname varchar(128), columnnumber int, columndatatype serializable, columndefault serializable, columndefaultid char(36), autoincrementvalue bigint, autoincrementstart bigint, autoincrementinc bigint, autoincrementcycle boolean )", "c90.dat", string2, string3, string4, string5);
        this.createTable(connection, string, "SYSSCHEMAS", "( schemaID char(36), schemaname varchar(128), authorizationid varchar(128) )", "cc0.dat", string2, string3, string4, string5);
        this.createTable(connection, string, "SYSTABLES", "( tableid char(36), tablename varchar(128), tabletype char(1), schemaid char(36), lockgranularity char(1) )", "c60.dat", string2, string3, string4, string5);
    }

    private void createTable(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws SQLException {
        String string9 = string + "." + string2;
        String string10 = DataFileVTI.class.getName();
        this.executeDDL(connection, "create function " + string9 + "\n(\n    databaseDirectoryName varchar( 32672 ),\n    dataFileName varchar( 32672 ),\n    tableSignature varchar( 32672 ),\n    encryptionAttributes varchar( 32672 ),\n    userName varchar( 32672 ),\n    password varchar( 32672 )\n)\nreturns table\n" + string3 + "language java\nparameter style derby_jdbc_result_set\nno sql\nexternal name '" + string10 + ".dataFileVTI'\n");
        this.executeDDL(connection, "create view " + string9 + "\nas select * from table\n(\n    " + string9 + "\n    (\n        '" + string5 + "',\n        '" + string4 + "',\n        '" + string3 + "',\n        " + this.singleQuote(string6) + ",\n        " + this.singleQuote(string7) + ",\n        " + this.singleQuote(string8) + "\n    )\n) t\n");
    }

    private void createUserSchemas(Connection connection, String string, String string2, String string3, String string4, String string5, String string6) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement(connection, "select schemaName\nfrom " + string + ".sysschemas\nwhere schemaName not like 'SYS%' and schemaName != 'NULLID' and schemaName != 'SQLJ'\n");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            String string7 = this.makeSchemaName(string2, resultSet.getString(1));
            this.executeDDL(connection, "create schema " + string7);
        }
        resultSet.close();
        preparedStatement.close();
    }

    private String makeSchemaName(String string, String string2) {
        return IdUtil.normalToDelimited((String)(string + string2));
    }

    private void createViews(Connection connection, String string, String string2, String string3, String string4, String string5, String string6, String string7) throws SQLException {
        File file = new File(string);
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(file);
        }
        catch (Exception exception) {
            throw this.wrap(exception);
        }
        String string8 = ((EmbedConnection)connection).getDBName();
        printWriter.println("connect 'jdbc:derby:" + string8 + "';\n");
        PreparedStatement preparedStatement = this.prepareStatement(connection, "select s.schemaName, t.tableName, g.conglomerateNumber, c.columnName, c.columnNumber, c.columnDatatype\nfrom " + string2 + ".sysschemas s,\n" + string2 + ".systables t,\n" + string2 + ".sysconglomerates g,\n" + string2 + ".syscolumns c\nwhere s.schemaName not like 'SYS%' and schemaName != 'NULLID' and schemaName != 'SQLJ'\nand s.schemaID = t.schemaID\nand t.tableID = g.tableID and not g.isindex\nand t.tableID = c.referenceID\norder by s.schemaName, t.tableName, c.columnNumber");
        ResultSet resultSet = preparedStatement.executeQuery();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<TypeDescriptor> arrayList2 = new ArrayList<TypeDescriptor>();
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        long l = -1L;
        while (resultSet.next()) {
            int n = 1;
            String string13 = resultSet.getString(n++);
            String string14 = resultSet.getString(n++);
            if (!string13.equals(string9)) {
                printWriter.println("create schema " + IdUtil.normalToDelimited((String)string13) + ";\n");
            }
            String string15 = this.makeSchemaName(string3, string13);
            String string16 = IdUtil.normalToDelimited((String)string14);
            if (!(string11 == null || string11.equals(string15) && string12.equals(string16))) {
                this.createView(connection, printWriter, string2, string9, string10, string11, string12, l, arrayList, arrayList2, string4, string5, string6, string7);
                arrayList.clear();
                arrayList2.clear();
            }
            string9 = string13;
            string10 = string14;
            string11 = string15;
            string12 = string16;
            l = resultSet.getLong(n++);
            arrayList.add(this.normalizeColumnName(resultSet.getString(n++)));
            int n2 = ++n;
            ++n;
            arrayList2.add((TypeDescriptor)resultSet.getObject(n2));
        }
        if (string11 != null) {
            this.createView(connection, printWriter, string2, string9, string10, string11, string12, l, arrayList, arrayList2, string4, string5, string6, string7);
        }
        resultSet.close();
        preparedStatement.close();
        printWriter.flush();
        printWriter.close();
    }

    private String normalizeColumnName(String string) {
        return dblook.addQuotes((String)dblook.expandDoubleQuotes((String)dblook.stripQuotes((String)dblook.addQuotes((String)string))));
    }

    private void createView(Connection connection, PrintWriter printWriter, String string, String string2, String string3, String string4, String string5, long l, ArrayList<String> arrayList, ArrayList<TypeDescriptor> arrayList2, String string6, String string7, String string8, String string9) throws SQLException {
        String string10 = "c" + Long.toHexString(l) + ".dat";
        String string11 = this.makeTableSignature(string, arrayList, arrayList2);
        String string12 = IdUtil.normalToDelimited((String)string2) + "." + IdUtil.normalToDelimited((String)string3);
        String string13 = string4 + "." + string5;
        printWriter.println("-- siphon data out of " + string10);
        printWriter.println("create table " + string12 + " as select * from " + string13 + " with no data;");
        printWriter.println("insert into " + string12 + " select * from " + string13 + ";\n");
        this.createTable(connection, string4, string5, string11, string10, string6, string7, string8, string9);
    }

    private String makeTableSignature(String string, ArrayList<String> arrayList, ArrayList<TypeDescriptor> arrayList2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("( ");
        for (int i = 0; i < arrayList.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(arrayList.get(i) + " ");
            TypeDescriptor typeDescriptor = arrayList2.get(i);
            if (typeDescriptor.isUserDefinedType()) {
                stringBuilder.append(string + ".serializable");
                continue;
            }
            stringBuilder.append(typeDescriptor.getSQLstring());
        }
        stringBuilder.append(" )");
        return stringBuilder.toString();
    }

    private String singleQuote(String string) {
        return string == null ? "null" : "'" + string + "'";
    }

    private void dropViews(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement(connection, "select s.schemaName, t.tableName\nfrom sys.sysschemas s, sys.systables t\nwhere s.schemaName like '" + string + "%'\nand s.schemaID = t.schemaID");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            int n = 1;
            this.dropTable(connection, IdUtil.normalToDelimited((String)resultSet.getString(n++)), IdUtil.normalToDelimited((String)resultSet.getString(n++)));
        }
        resultSet.close();
        preparedStatement.close();
    }

    private void dropTable(Connection connection, String string, String string2) throws SQLException {
        String string3 = string + "." + string2;
        this.executeDDL(connection, "drop view " + string3);
        this.executeDDL(connection, "drop function " + string3);
    }

    private void dropUserSchemas(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement(connection, "select s.schemaName\nfrom sys.sysschemas s\nwhere s.schemaName like '" + string + "%'\n");
        ResultSet resultSet = preparedStatement.executeQuery();
        while (resultSet.next()) {
            String string2 = IdUtil.normalToDelimited((String)resultSet.getString(1));
            this.executeDDL(connection, "drop schema " + string2 + " restrict");
        }
        resultSet.close();
        preparedStatement.close();
    }

    private void dropControlSchema(Connection connection, String string) throws SQLException {
        this.executeDDL(connection, "set schema sys");
        this.dropTable(connection, string, "SYSTABLES");
        this.dropTable(connection, string, "SYSSCHEMAS");
        this.dropTable(connection, string, "SYSCOLUMNS");
        this.dropTable(connection, string, "SYSCONGLOMERATES");
        this.executeDDL(connection, "drop type " + string + ".serializable restrict");
        this.executeDDL(connection, "drop schema " + string + " restrict");
    }

    private Connection getDerbyConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:default:connection");
    }

    private String delimitedID(String string) {
        return IdUtil.normalToDelimited((String)string);
    }

    private String stringLiteral(String string) {
        return StringUtil.quoteStringLiteral((String)string);
    }

    private void executeDDL(Connection connection, String string) throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement(connection, string);
        preparedStatement.execute();
        preparedStatement.close();
    }

    private PreparedStatement prepareStatement(Connection connection, String string) throws SQLException {
        return connection.prepareStatement(string);
    }

    private SQLException wrap(Throwable throwable) {
        String string = throwable.getMessage();
        String string2 = "XJ001.U".substring(0, 5);
        return new SQLException(string, string2, throwable);
    }
}

